/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.concurrent.flow;

import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Flow;

public class ConcatProcessor<T>
implements Flow.Processor<T, T> {
    private final List<Flow.Publisher<T>> publishers;
    private Flow.Subscriber<? super T> subscriber;
    private Flow.Subscription sourceSubscription;
    private int sourceIndex;
    private int nPending;

    public ConcatProcessor(List<Flow.Publisher<T>> publishers) {
        this.publishers = publishers;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        this.subscriber = subscriber;
        Subscription targetSubscription = new Subscription();
        subscriber.onSubscribe(targetSubscription);
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        this.sourceSubscription = subscription;
        if (this.nPending > 0) {
            this.sourceSubscription.request(this.nPending);
        }
    }

    @Override
    public void onNext(T item) {
        --this.nPending;
        this.subscriber.onNext(item);
    }

    @Override
    public void onError(Throwable error) {
        this.sourceSubscription = null;
        Throwable completionError = error instanceof CompletionException ? error : new CompletionException(error.getMessage(), error);
        this.subscriber.onError(completionError);
    }

    @Override
    public void onComplete() {
        this.sourceSubscription = null;
        ++this.sourceIndex;
        if (this.sourceIndex < this.publishers.size()) {
            this.publishers.get(this.sourceIndex).subscribe(this);
        } else {
            this.subscriber.onComplete();
        }
    }

    private class Subscription
    implements Flow.Subscription {
        private Subscription() {
        }

        @Override
        public void request(long n) {
            ConcatProcessor.this.nPending = (int)((long)ConcatProcessor.this.nPending + n);
            if (ConcatProcessor.this.sourceSubscription != null) {
                ConcatProcessor.this.sourceSubscription.request(ConcatProcessor.this.nPending);
            }
        }

        @Override
        public void cancel() {
            if (ConcatProcessor.this.sourceSubscription != null) {
                ConcatProcessor.this.sourceSubscription.cancel();
                ConcatProcessor.this.sourceSubscription = null;
            }
        }
    }
}

