/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.concurrent.flow;

import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;

public class DelayedSubscriber<T>
implements Flow.Subscriber<T> {
    private final Flow.Subscriber<T> subscriber;
    private final CompletionStage<?> signal;

    public DelayedSubscriber(Flow.Subscriber<T> subscriber, CompletionStage<?> signal) {
        this.subscriber = subscriber;
        this.signal = signal;
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        this.signal.whenComplete((result, error) -> {
            if (error == null) {
                this.subscriber.onSubscribe(subscription);
            } else {
                subscription.cancel();
                this.subscriber.onError((Throwable)error);
            }
        });
    }

    @Override
    public void onNext(T item) {
        this.subscriber.onNext(item);
    }

    @Override
    public void onError(Throwable throwable) {
        this.subscriber.onError(throwable);
    }

    @Override
    public void onComplete() {
        this.subscriber.onComplete();
    }
}

