/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.concurrent.flow;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Flow;

public class FutureFirstItemSubscriber<T>
implements Flow.Subscriber<T> {
    private final CompletableFuture<T> firstFuture;
    private Flow.Subscription subscription;

    public FutureFirstItemSubscriber(CompletableFuture<T> firstFuture) {
        this.firstFuture = firstFuture;
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        this.subscription = subscription;
        subscription.request(1L);
    }

    @Override
    public void onNext(T item) {
        this.firstFuture.complete(item);
        this.subscription.cancel();
    }

    @Override
    public void onError(Throwable error) {
        if (!this.firstFuture.isDone()) {
            Throwable completionError = error instanceof CompletionException ? error : new CompletionException(error.getMessage(), error);
            this.firstFuture.completeExceptionally(completionError);
        }
    }

    @Override
    public void onComplete() {
        if (!this.firstFuture.isDone()) {
            this.firstFuture.completeExceptionally(new IllegalStateException());
        }
    }
}

