/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.concurrent.flow;

import java.util.concurrent.CompletionException;
import java.util.concurrent.Flow;
import java.util.function.Function;

public class MapProcessor<T, U>
implements Flow.Processor<T, U> {
    private final Function<T, U> mapping;
    private Flow.Subscriber<? super U> subscriber = null;
    private Flow.Subscription sourceSubscription = null;
    private int bufferRequest;
    private boolean bufferCancel;

    public MapProcessor(Function<T, U> mapping) {
        this.mapping = mapping;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super U> subscriber) {
        this.subscriber = subscriber;
        MapSubscription targetSubscription = new MapSubscription();
        subscriber.onSubscribe(targetSubscription);
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        this.sourceSubscription = subscription;
        if (this.bufferCancel) {
            subscription.cancel();
            this.bufferCancel = false;
        } else if (this.bufferRequest > 0) {
            subscription.request(this.bufferRequest);
            this.bufferRequest = 0;
        }
    }

    @Override
    public void onNext(T item) {
        try {
            U mappedItem = this.mapping.apply(item);
            this.subscriber.onNext(mappedItem);
        }
        catch (Throwable e) {
            this.subscriber.onError(e);
        }
    }

    @Override
    public void onError(Throwable error) {
        Throwable completionError = error instanceof CompletionException ? error : new CompletionException(error.getMessage(), error);
        this.subscriber.onError(completionError);
    }

    @Override
    public void onComplete() {
        this.subscriber.onComplete();
    }

    private class MapSubscription
    implements Flow.Subscription {
        private MapSubscription() {
        }

        @Override
        public void request(long n) {
            if (MapProcessor.this.sourceSubscription != null) {
                MapProcessor.this.sourceSubscription.request(n);
            } else {
                MapProcessor.this.bufferRequest = (int)((long)MapProcessor.this.bufferRequest + n);
            }
        }

        @Override
        public void cancel() {
            if (MapProcessor.this.sourceSubscription != null) {
                MapProcessor.this.sourceSubscription.cancel();
            } else {
                MapProcessor.this.bufferCancel = true;
            }
        }
    }
}

