/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.config;

import com.google.common.io.Files;
import java.net.URI;
import java.util.List;
import org.finos.tracdap.common.exception.EStartup;

public enum ConfigFormat {
    YAML("yaml", "yml"),
    JSON("json"),
    PROTO("proto");

    private final List<String> extensions;

    private ConfigFormat(String ... extensions) {
        this.extensions = List.of(extensions);
    }

    public static ConfigFormat fromExtension(URI configFileUrl) {
        String path = configFileUrl.getPath();
        String ext = Files.getFileExtension((String)path);
        if (ext.isEmpty()) {
            throw new EStartup(String.format("Unknown config format for file: [%s]", configFileUrl));
        }
        for (ConfigFormat format : ConfigFormat.values()) {
            if (!format.extensions.contains(ext)) continue;
            return format;
        }
        throw new EStartup(String.format("Unknown config format for file: [%s]", configFileUrl));
    }
}

