/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.config;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import org.finos.tracdap.common.config.ConfigFormat;
import org.finos.tracdap.common.exception.EConfigParse;
import org.finos.tracdap.common.exception.EUnexpected;

public class ConfigParser {
    public static <TConfig extends Message> TConfig parseConfig(byte[] configData, ConfigFormat configFormat, Class<TConfig> configClass) {
        return ConfigParser.parseConfig(configData, configFormat, configClass, false);
    }

    public static <TConfig extends Message> TConfig parseConfig(byte[] configData, ConfigFormat configFormat, Class<TConfig> configClass, boolean leniency) {
        try {
            Method newBuilder = configClass.getMethod("newBuilder", new Class[0]);
            Message.Builder builder = (Message.Builder)newBuilder.invoke(null, new Object[0]);
            switch (configFormat) {
                case PROTO: {
                    return ConfigParser.parseProtoConfig(configData, builder);
                }
                case JSON: {
                    return ConfigParser.parseJsonConfig(configData, builder, leniency);
                }
                case YAML: {
                    return ConfigParser.parseYamlConfig(configData, builder, leniency);
                }
            }
            throw new EConfigParse(String.format("Unknown config format [%s]", new Object[]{configFormat}));
        }
        catch (InvalidProtocolBufferException e) {
            throw new EConfigParse("Invalid config: " + e.getMessage(), e);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new EUnexpected();
        }
    }

    private static <TConfig extends Message> TConfig parseProtoConfig(byte[] protoData, Message.Builder builder) throws InvalidProtocolBufferException {
        return (TConfig)builder.mergeFrom(protoData).build();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static <TConfig extends Message> TConfig parseJsonConfig(byte[] jsonData, Message.Builder builder, boolean lenient) throws InvalidProtocolBufferException {
        JsonFormat.Parser parser = JsonFormat.parser();
        if (lenient) {
            parser = parser.ignoringUnknownFields();
        }
        try (ByteArrayInputStream in = new ByteArrayInputStream(jsonData);){
            Message message;
            try (InputStreamReader reader = new InputStreamReader((InputStream)in, StandardCharsets.UTF_8);){
                parser.merge((Reader)reader, builder);
                message = builder.build();
            }
            return (TConfig)message;
        }
        catch (InvalidProtocolBufferException e) {
            throw e;
        }
        catch (IOException e) {
            throw new EUnexpected();
        }
    }

    private static <TConfig extends Message> TConfig parseYamlConfig(byte[] yamlData, Message.Builder builder, boolean leniency) throws InvalidProtocolBufferException {
        try {
            YAMLFactory yamlFactory = new YAMLFactory();
            JsonFactory jsonFactory = new JsonFactory();
            YAMLMapper reader = new YAMLMapper(yamlFactory);
            JsonMapper writer = new JsonMapper(jsonFactory);
            Object obj = reader.readValue(yamlData, Object.class);
            byte[] json = writer.writeValueAsBytes(obj);
            return ConfigParser.parseJsonConfig(json, builder, leniency);
        }
        catch (InvalidProtocolBufferException e) {
            throw e;
        }
        catch (IOException e) {
            throw new EConfigParse("Invalid config: " + e.getMessage(), e);
        }
    }

    public static <TConfig extends Message> byte[] quoteConfig(TConfig config, ConfigFormat configFormat) {
        try {
            switch (configFormat) {
                case PROTO: {
                    return ConfigParser.quoteProtoConfig(config);
                }
                case JSON: {
                    return ConfigParser.quoteJsonConfig(config);
                }
                case YAML: {
                    return ConfigParser.quoteYamlConfig(config);
                }
            }
            throw new EConfigParse(String.format("Unknown config format [%s]", new Object[]{configFormat}));
        }
        catch (InvalidProtocolBufferException error) {
            throw new EConfigParse("Invalid config: " + error.getMessage(), error);
        }
    }

    private static <TConfig extends Message> byte[] quoteProtoConfig(TConfig config) throws InvalidProtocolBufferException {
        return config.toByteArray();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static <TConfig extends Message> byte[] quoteJsonConfig(TConfig config) throws InvalidProtocolBufferException {
        JsonFormat.Printer quoter = JsonFormat.printer();
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            byte[] byArray;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);){
                quoter.appendTo(config, (Appendable)writer);
                writer.flush();
                byArray = out.toByteArray();
            }
            return byArray;
        }
        catch (InvalidProtocolBufferException e) {
            throw e;
        }
        catch (IOException e) {
            throw new EUnexpected();
        }
    }

    private static <TConfig extends Message> byte[] quoteYamlConfig(TConfig config) throws InvalidProtocolBufferException {
        try {
            byte[] json = ConfigParser.quoteJsonConfig(config);
            JsonFactory jsonFactory = new JsonFactory();
            YAMLFactory yamlFactory = new YAMLFactory();
            JsonMapper reader = new JsonMapper(jsonFactory);
            YAMLMapper writer = new YAMLMapper(yamlFactory);
            Object obj = reader.readValue(json, Object.class);
            return writer.writeValueAsBytes(obj);
        }
        catch (InvalidProtocolBufferException e) {
            throw e;
        }
        catch (IOException e) {
            throw new EConfigParse("Invalid config: " + e.getMessage(), e);
        }
    }
}

