/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.grpc;

import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionException;
import org.finos.tracdap.common.exception.EAuthorization;
import org.finos.tracdap.common.exception.EData;
import org.finos.tracdap.common.exception.EInputValidation;
import org.finos.tracdap.common.exception.EMetadataBadUpdate;
import org.finos.tracdap.common.exception.EMetadataCorrupt;
import org.finos.tracdap.common.exception.EMetadataDuplicate;
import org.finos.tracdap.common.exception.EMetadataNotFound;
import org.finos.tracdap.common.exception.EMetadataWrongType;
import org.finos.tracdap.common.exception.EPluginNotAvailable;
import org.finos.tracdap.common.exception.ETenantNotFound;
import org.finos.tracdap.common.exception.ETracInternal;
import org.finos.tracdap.common.exception.ETracPublic;
import org.finos.tracdap.common.exception.EVersionValidation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcErrorMapping {
    private static final Logger log = LoggerFactory.getLogger(GrpcErrorMapping.class);
    private static final List<Map.Entry<Class<? extends Throwable>, Status.Code>> ERROR_MAPPING = List.of(Map.entry(EAuthorization.class, Status.Code.PERMISSION_DENIED), Map.entry(EInputValidation.class, Status.Code.INVALID_ARGUMENT), Map.entry(EVersionValidation.class, Status.Code.FAILED_PRECONDITION), Map.entry(ETenantNotFound.class, Status.Code.NOT_FOUND), Map.entry(EMetadataNotFound.class, Status.Code.NOT_FOUND), Map.entry(EMetadataDuplicate.class, Status.Code.ALREADY_EXISTS), Map.entry(EMetadataWrongType.class, Status.Code.FAILED_PRECONDITION), Map.entry(EMetadataBadUpdate.class, Status.Code.FAILED_PRECONDITION), Map.entry(EMetadataCorrupt.class, Status.Code.DATA_LOSS), Map.entry(EData.class, Status.Code.DATA_LOSS), Map.entry(EPluginNotAvailable.class, Status.Code.UNIMPLEMENTED));

    public static StatusRuntimeException processError(Throwable error) {
        if (error instanceof CompletionException) {
            error = error.getCause();
        }
        if (error instanceof StatusException) {
            StatusException upstreamError = (StatusException)error;
            return upstreamError.getStatus().withCause((Throwable)upstreamError).asRuntimeException();
        }
        if (error instanceof StatusRuntimeException) {
            StatusRuntimeException upstreamError = (StatusRuntimeException)error;
            return upstreamError.getStatus().withCause((Throwable)upstreamError).asRuntimeException();
        }
        if (error instanceof ETracInternal) {
            return Status.fromCode((Status.Code)Status.Code.INTERNAL).withDescription(Status.INTERNAL.getDescription()).withCause(error).asRuntimeException();
        }
        if (error instanceof ETracPublic) {
            Status.Code errorCode = GrpcErrorMapping.lookupErrorCode(error);
            if (errorCode != null) {
                return Status.fromCode((Status.Code)errorCode).withDescription(error.getMessage()).withCause(error).asRuntimeException();
            }
            log.warn("No gRPC error code mapping is available for the error {}", (Object)error.getClass().getSimpleName());
            return Status.fromCode((Status.Code)Status.Code.INTERNAL).withDescription(Status.INTERNAL.getDescription()).withCause(error).asRuntimeException();
        }
        log.error("An unhandled error has reached the top level error handler", error);
        return Status.fromCode((Status.Code)Status.Code.INTERNAL).withDescription(Status.INTERNAL.getDescription()).withCause(error).asRuntimeException();
    }

    private static Status.Code lookupErrorCode(Throwable error) {
        for (Map.Entry<Class<? extends Throwable>, Status.Code> mapping : ERROR_MAPPING) {
            if (!mapping.getKey().isInstance(error)) continue;
            return mapping.getValue();
        }
        return null;
    }
}

