/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.grpc;

import io.grpc.MethodDescriptor;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.function.Function;
import org.finos.tracdap.common.concurrent.Flows;
import org.finos.tracdap.common.grpc.GrpcErrorMapping;
import org.finos.tracdap.common.grpc.GrpcServerRequestStream;
import org.finos.tracdap.common.grpc.GrpcServerResponseStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcServerWrap {
    private final Logger log;

    public GrpcServerWrap(Class<?> apiClass) {
        this.log = LoggerFactory.getLogger(apiClass);
    }

    public <TRequest, TResponse> void unaryCall(MethodDescriptor<TRequest, TResponse> method, TRequest request, StreamObserver<TResponse> responseObserver, Function<TRequest, CompletionStage<TResponse>> methodImpl) {
        try {
            this.log.info("API CALL START: [{}]", (Object)method.getBareMethodName());
            methodImpl.apply(request).handle((result, error) -> this.handleResult(method, responseObserver, (Object)result, (Throwable)error));
        }
        catch (Exception error2) {
            StatusRuntimeException grpcError = GrpcErrorMapping.processError(error2);
            this.log.error("API CALL FAILED: [{}] {}", new Object[]{method.getBareMethodName(), grpcError.getMessage(), grpcError});
            responseObserver.onError((Throwable)grpcError);
        }
    }

    public <TRequest, TResponse> void serverStreaming(MethodDescriptor<TRequest, TResponse> method, TRequest request, StreamObserver<TResponse> responseObserver, Function<TRequest, Flow.Publisher<TResponse>> methodImpl) {
        try {
            this.log.info("API CALL START: [{}] (server streaming)", (Object)method.getBareMethodName());
            Flow.Publisher<TResponse> resultPublisher = methodImpl.apply(request);
            Flow.Processor<Object, Object> resultLogger = Flows.interceptResult(resultPublisher, (result, error) -> this.logResult(method, (Throwable)error));
            GrpcServerResponseStream<TResponse> resultSubscriber = new GrpcServerResponseStream<TResponse>(responseObserver);
            resultLogger.subscribe(resultSubscriber);
        }
        catch (Exception error2) {
            StatusRuntimeException grpcError = GrpcErrorMapping.processError(error2);
            this.log.error("API CALL FAILED: [{}] {}", new Object[]{method.getBareMethodName(), grpcError.getMessage(), grpcError});
            responseObserver.onError((Throwable)grpcError);
        }
    }

    public <TRequest, TResponse> StreamObserver<TRequest> clientStreaming(MethodDescriptor<TRequest, TResponse> method, StreamObserver<TResponse> responseObserver, Function<Flow.Publisher<TRequest>, CompletionStage<TResponse>> methodImpl) {
        try {
            this.log.info("API CALL START: [{}] (client streaming)", (Object)method.getBareMethodName());
            Flow.Processor requestStream = Flows.passThrough();
            methodImpl.apply(requestStream).handle((result, error) -> this.handleResult(method, responseObserver, (Object)result, (Throwable)error));
            return new GrpcServerRequestStream(requestStream);
        }
        catch (Exception error2) {
            StatusRuntimeException grpcError = GrpcErrorMapping.processError(error2);
            this.log.error("API CALL FAILED: [{}] {}", new Object[]{method.getBareMethodName(), grpcError.getMessage(), grpcError});
            responseObserver.onError((Throwable)grpcError);
            return null;
        }
    }

    private <TResponse> Void handleResult(MethodDescriptor<?, TResponse> method, StreamObserver<TResponse> responseObserver, TResponse result, Throwable error) {
        if (error == null) {
            this.log.info("API CALL SUCCEEDED: [{}]", (Object)method.getBareMethodName());
            responseObserver.onNext(result);
            responseObserver.onCompleted();
        } else {
            StatusRuntimeException grpcError = GrpcErrorMapping.processError(error);
            this.log.error("API CALL FAILED: [{}] {}", new Object[]{method.getBareMethodName(), grpcError.getMessage(), grpcError});
            responseObserver.onError((Throwable)grpcError);
        }
        return null;
    }

    private <TResponse> void logResult(MethodDescriptor<?, TResponse> method, Throwable error) {
        if (error == null) {
            this.log.info("API CALL SUCCEEDED: [{}]", (Object)method.getBareMethodName());
        } else {
            StatusRuntimeException grpcError = GrpcErrorMapping.processError(error);
            this.log.error("API CALL FAILED: [{}] {}", new Object[]{method.getBareMethodName(), grpcError.getMessage(), grpcError});
        }
    }
}

