/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.metadata;

import java.time.Instant;
import org.finos.tracdap.common.exception.EUnexpected;
import org.finos.tracdap.common.metadata.MetadataCodec;
import org.finos.tracdap.metadata.TagHeader;
import org.finos.tracdap.metadata.TagSelector;

public class MetadataUtil {
    private static final String OBJECT_KEY_FOR_VERSION = "%s-%s-v%d";
    private static final String OBJECT_KEY_FOR_ASOF = "%s-%s-asof-%s";
    private static final String OBJECT_KEY_FOR_LATEST = "%s-%s-latest";

    public static TagSelector selectorFor(TagHeader header) {
        return MetadataUtil.selectorFor(header, false, false);
    }

    public static TagSelector selectorForLatest(TagHeader header) {
        return MetadataUtil.selectorFor(header, true, true);
    }

    public static TagSelector selectorFor(TagHeader header, boolean latestObject, boolean latestTag) {
        TagSelector.Builder selector = TagSelector.newBuilder().setObjectType(header.getObjectType()).setObjectId(header.getObjectId());
        if (latestObject) {
            selector.setLatestObject(true);
        } else {
            selector.setObjectVersion(header.getObjectVersion());
        }
        if (latestTag) {
            selector.setLatestTag(true);
        } else {
            selector.setTagVersion(header.getTagVersion());
        }
        return selector.build();
    }

    public static TagSelector priorVersion(TagHeader header) {
        return TagSelector.newBuilder().setObjectType(header.getObjectType()).setObjectId(header.getObjectId()).setObjectVersion(header.getObjectVersion() - 1).setLatestTag(true).build();
    }

    public static TagHeader nextObjectVersion(TagHeader header, Instant timestamp) {
        return header.toBuilder().setObjectVersion(header.getObjectVersion() + 1).setObjectTimestamp(MetadataCodec.encodeDatetime(timestamp)).setTagVersion(1).setTagTimestamp(MetadataCodec.encodeDatetime(timestamp)).build();
    }

    public static TagHeader nextTagVersion(TagHeader header, Instant timestamp) {
        return header.toBuilder().setTagVersion(header.getTagVersion() + 1).setTagTimestamp(MetadataCodec.encodeDatetime(timestamp)).build();
    }

    public static TagSelector preallocated(TagSelector selector) {
        return TagSelector.newBuilder().setObjectType(selector.getObjectType()).setObjectId(selector.getObjectId()).setObjectVersion(0).setTagVersion(0).build();
    }

    public static String objectKey(TagHeader header) {
        return String.format(OBJECT_KEY_FOR_VERSION, header.getObjectType(), header.getObjectId(), header.getObjectVersion());
    }

    public static String objectKey(TagSelector selector) {
        if (selector.hasObjectVersion()) {
            return String.format(OBJECT_KEY_FOR_VERSION, selector.getObjectType(), selector.getObjectId(), selector.getObjectVersion());
        }
        if (selector.hasObjectAsOf()) {
            return String.format(OBJECT_KEY_FOR_ASOF, selector.getObjectType(), selector.getObjectId(), selector.getObjectAsOf().getIsoDatetime());
        }
        if (selector.hasLatestObject()) {
            return String.format(OBJECT_KEY_FOR_LATEST, selector.getObjectType(), selector.getObjectId());
        }
        throw new EUnexpected();
    }
}

