/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.finos.tracdap.common.plugin.ITracPlugin;
import org.finos.tracdap.common.plugin.PluginServiceInfo;

public abstract class TracPlugin
implements ITracPlugin {
    protected abstract <T> T createService(String var1, Properties var2);

    @Override
    public final List<String> protocols(Class<?> service) {
        List<PluginServiceInfo> psi = this.serviceInfo();
        List matchingPsi = psi.stream().filter(si -> si.serviceClass() == service).collect(Collectors.toList());
        if (matchingPsi.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return matchingPsi.stream().map(PluginServiceInfo::protocols).reduce(new ArrayList(), (ps, p) -> {
            ps.addAll(p);
            return ps;
        });
    }

    @Override
    public final <T> T createService(Class<T> serviceClass, String protocol, Properties properties) {
        List<PluginServiceInfo> psi = this.serviceInfo();
        Optional<PluginServiceInfo> matchingPsi = psi.stream().filter(psi_ -> TracPlugin.psiMatch(psi_, serviceClass, protocol)).findFirst();
        if (matchingPsi.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return this.createService(matchingPsi.get().serviceName(), properties);
    }

    protected static boolean psiMatch(PluginServiceInfo psi, Class<?> service, String protocol) {
        if (psi.serviceClass() != service) {
            return false;
        }
        for (String psiProtocol : psi.protocols()) {
            if (!psiProtocol.equalsIgnoreCase(protocol)) continue;
            return true;
        }
        return false;
    }
}

