/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.service;

import java.lang.reflect.Constructor;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.impl.Log4jContextFactory;
import org.apache.logging.log4j.core.util.DefaultShutdownCallbackRegistry;
import org.finos.tracdap.common.config.ConfigManager;
import org.finos.tracdap.common.exception.EStartup;
import org.finos.tracdap.common.exception.ETrac;
import org.finos.tracdap.common.plugin.PluginManager;
import org.finos.tracdap.common.startup.Startup;
import org.finos.tracdap.common.startup.StartupSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonServiceBase {
    private static final Duration DEFAULT_STARTUP_TIMEOUT = Duration.of(30L, ChronoUnit.SECONDS);
    private static final Duration DEFAULT_SHUTDOWN_TIMEOUT = Duration.of(30L, ChronoUnit.SECONDS);
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Duration startupTimeout = DEFAULT_STARTUP_TIMEOUT;
    private final Duration shutdownTimeout = DEFAULT_SHUTDOWN_TIMEOUT;

    protected abstract void doStartup(Duration var1) throws InterruptedException;

    protected abstract int doShutdown(Duration var1) throws InterruptedException;

    protected boolean shutdownResource(String resourceName, Instant deadline, ShutdownAction action) {
        boolean ok;
        Duration remaining = Duration.between(Instant.now(), deadline);
        Duration safeRemaining = remaining.isNegative() ? Duration.ZERO : remaining;
        try {
            ok = action.apply(safeRemaining);
        }
        catch (InterruptedException e) {
            ok = false;
            Thread.currentThread().interrupt();
        }
        if (ok) {
            this.log.info("{} has gone down", (Object)resourceName);
        } else {
            this.log.error("{} did not go down cleanly", (Object)resourceName);
        }
        return ok;
    }

    public static void svcMain(Class<? extends CommonServiceBase> svcClass, String[] args) {
        try {
            StartupSequence startup = Startup.useCommandLine(svcClass, args);
            startup.runStartupSequence();
            PluginManager plugins = startup.getPlugins();
            ConfigManager config = startup.getConfig();
            Constructor<? extends CommonServiceBase> constructor = svcClass.getConstructor(PluginManager.class, ConfigManager.class);
            CommonServiceBase service = constructor.newInstance(plugins, config);
            service.start(true);
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
        }
        catch (EStartup e) {
            if (e.isQuiet()) {
                System.exit(e.getExitCode());
            }
            System.err.println("Service failed to start: " + e.getMessage());
            e.printStackTrace(System.err);
            System.exit(e.getExitCode());
        }
        catch (ETrac e) {
            System.err.println("Service failed to start: " + e.getMessage());
            e.printStackTrace(System.err);
            System.exit(-1);
        }
        catch (InterruptedException e) {
            System.err.println("Service failed to start: Startup sequence was interrupted");
            Thread.currentThread().interrupt();
            System.exit(-2);
        }
        catch (NoSuchMethodException e) {
            System.err.println("Service failed to start: Missing required service constructor for svcMain (this is a bug)");
            System.err.println(e.getMessage());
            e.printStackTrace(System.err);
            System.exit(-3);
        }
        catch (Exception e) {
            System.err.println("Service failed to start: There was an unhandled error during startup (this is a bug)");
            System.err.println(e.getMessage());
            e.printStackTrace(System.err);
            System.exit(-3);
        }
    }

    public void start() {
        this.start(false);
    }

    public void start(boolean registerShutdownHook) {
        try {
            this.log.info("Service is coming up...");
            this.timedSequence(t -> {
                this.doStartup(t);
                return null;
            }, this.startupTimeout, "startup");
            if (registerShutdownHook) {
                Thread shutdownThread = new Thread(this::jvmShutdownHook, "shutdown");
                Runtime.getRuntime().addShutdownHook(shutdownThread);
            }
            this.disableLog4jShutdownHook();
            this.log.info("Service is up and running");
        }
        catch (ETrac e) {
            if (e instanceof EStartup && ((EStartup)e).isQuiet()) {
                throw e;
            }
            String errorMessage = "Service failed to start: " + e.getMessage();
            this.log.error(errorMessage, (Throwable)e);
            throw e;
        }
        catch (InterruptedException e) {
            this.log.error("Service failed to start: Startup sequence was interrupted");
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            this.log.error("Service failed to start: There was an unhandled error during startup (this is a bug)");
            this.log.error(e.getMessage(), (Throwable)e);
            throw new EStartup(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stop() {
        try {
            this.log.info("Service is going down...");
            Integer exitCode = this.timedSequence(this::doShutdown, this.shutdownTimeout, "shutdown");
            if (exitCode == 0) {
                this.log.info("Service has gone down cleanly");
            } else {
                this.log.error("Service has gone down with errors");
            }
            int n = exitCode;
            return n;
        }
        catch (ETrac e) {
            String errorMessage = "Service did not stop cleanly: " + e.getMessage();
            this.log.error(errorMessage, (Throwable)e);
            int n = -1;
            return n;
        }
        catch (InterruptedException e) {
            this.log.error("Service did not stop cleanly: Shutdown sequence was interrupted");
            Thread.currentThread().interrupt();
            int n = -2;
            return n;
        }
        catch (Exception e) {
            this.log.error("Service did not stop cleanly: There was an unhandled error during shutdown (this is a bug)");
            this.log.error(e.getMessage(), (Throwable)e);
            int n = -3;
            return n;
        }
        finally {
            this.explicitLog4jShutdown();
        }
    }

    private <TResult> TResult timedSequence(TimedSequence<TResult> sequence, final Duration timeout, final String sequenceName) throws InterruptedException {
        final Thread thread = Thread.currentThread();
        TimerTask interruptTask = new TimerTask(){

            @Override
            public void run() {
                CommonServiceBase.this.log.error("Timeout expired for {} sequence ({} seconds)", (Object)sequenceName, (Object)timeout.getSeconds());
                thread.interrupt();
            }
        };
        long timeoutMillis = (timeout.getSeconds() + 1L) * 1000L;
        Timer timer = new Timer(sequenceName + "_timer", true);
        timer.schedule(interruptTask, timeoutMillis);
        TResult result = sequence.run(timeout);
        timer.cancel();
        if (thread.isInterrupted()) {
            throw new InterruptedException();
        }
        return result;
    }

    private void disableLog4jShutdownHook() {
        try {
            Log4jContextFactory logFactory = (Log4jContextFactory)LogManager.getFactory();
            ((DefaultShutdownCallbackRegistry)logFactory.getShutdownCallbackRegistry()).stop();
        }
        catch (Exception e) {
            this.log.warn("Logging shutdown hook is active (shutdown messages may be lost)");
        }
    }

    private void explicitLog4jShutdown() {
        org.apache.logging.log4j.spi.LoggerContext logContext = LogManager.getContext();
        if (logContext instanceof LoggerContext) {
            Configurator.shutdown((LoggerContext)((LoggerContext)logContext));
        }
    }

    private void jvmShutdownHook() {
        this.log.info("Shutdown request received");
        int exitCode = this.stop();
        Runtime.getRuntime().halt(exitCode);
    }

    @FunctionalInterface
    private static interface TimedSequence<TResult> {
        public TResult run(Duration var1) throws InterruptedException;
    }

    @FunctionalInterface
    protected static interface ShutdownAction {
        public boolean apply(Duration var1) throws InterruptedException;
    }
}

