/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.startup;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.finos.tracdap.common.config.ConfigManager;
import org.finos.tracdap.common.startup.StandardArgs;
import org.finos.tracdap.common.startup.StandardArgsProcessor;
import org.finos.tracdap.common.startup.StartupSequence;
import org.finos.tracdap.common.util.VersionInfo;

public class Startup {
    public static StartupSequence useCommandLine(Class<?> serviceClass, String[] args) {
        return Startup.useCommandLine(serviceClass, args, List.of());
    }

    public static StartupSequence useCommandLine(Class<?> serviceClass, String[] args, List<StandardArgs.Task> tasks) {
        StartupSequence.printBanner(serviceClass);
        String componentName = VersionInfo.getComponentName(serviceClass);
        StandardArgs standardArgs = StandardArgsProcessor.processArgs(componentName, args, tasks);
        return new StartupSequence(serviceClass, standardArgs, false);
    }

    public static StartupSequence useConfigFile(Class<?> serviceClass, String configFile) {
        String keystoreKey = "";
        return Startup.useConfigFile(serviceClass, configFile, keystoreKey);
    }

    public static StartupSequence useConfigFile(Class<?> serviceClass, String configFile, String keystoreKey) {
        Path workingDir = Paths.get(".", new String[0]).toAbsolutePath().normalize();
        return Startup.useConfigFile(serviceClass, workingDir, configFile, keystoreKey);
    }

    public static StartupSequence useConfigFile(Class<?> serviceClass, Path workingDir, String configFile, String keystoreKey) {
        StartupSequence.printBanner(serviceClass);
        StandardArgs standardArgs = new StandardArgs(workingDir, configFile, keystoreKey);
        return new StartupSequence(serviceClass, standardArgs, false);
    }

    public static ConfigManager quickConfig(Path workingDir, String configFile, String keystoreKey) {
        StandardArgs standardArgs = new StandardArgs(workingDir, configFile, keystoreKey);
        StartupSequence startup = new StartupSequence(null, standardArgs, false);
        startup.runStartupSequence();
        return startup.getConfig();
    }
}

