/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.function.Consumer;

public class ByteOutputChannel
implements WritableByteChannel {
    private static final int CHUNK_SIZE = 4096;
    private final ByteBufAllocator allocator;
    private final Consumer<ByteBuf> sink;
    private final boolean useBuffering;
    private CompositeByteBuf buffer;
    private boolean isOpen = true;

    public ByteOutputChannel(Consumer<ByteBuf> sink) {
        this(sink, ByteBufAllocator.DEFAULT);
    }

    public ByteOutputChannel(Consumer<ByteBuf> sink, ByteBufAllocator allocator) {
        this(sink, allocator, true);
    }

    public ByteOutputChannel(Consumer<ByteBuf> sink, ByteBufAllocator allocator, boolean useBuffering) {
        this.allocator = allocator;
        this.sink = sink;
        this.useBuffering = useBuffering;
        this.buffer = null;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (!this.isOpen) {
            throw new IOException("Channel is already closed");
        }
        ByteBuf chunkBuf = this.allocator.directBuffer(src.remaining());
        chunkBuf.writeBytes(src);
        int chunkRemaining = chunkBuf.readableBytes();
        if (!this.useBuffering) {
            this.sink.accept(chunkBuf);
            return chunkRemaining;
        }
        int bytesWritten = 0;
        while (chunkRemaining > 0) {
            if (this.buffer == null) {
                this.buffer = this.allocator.compositeBuffer();
            }
            int bufferRemaining = 4096 - this.buffer.readableBytes();
            int sliceSize = Math.min(chunkBuf.readableBytes(), bufferRemaining);
            ByteBuf slice = chunkBuf.readSlice(sliceSize);
            slice.retain();
            this.buffer.addComponent(true, slice);
            bytesWritten += sliceSize;
            chunkRemaining = chunkBuf.readableBytes();
            if (this.buffer.readableBytes() != 4096) continue;
            this.sink.accept((ByteBuf)this.buffer);
            this.buffer = null;
        }
        chunkBuf.release();
        return bytesWritten;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void close() throws IOException {
        this.isOpen = false;
        if (this.buffer != null) {
            this.sink.accept((ByteBuf)this.buffer);
            this.buffer = null;
        }
    }
}

