/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Consumer;

public class ByteOutputStream
extends OutputStream {
    private static final int DEFAULT_CHUNK_SIZE = 4096;
    private final ByteBufAllocator allocator;
    private final Consumer<ByteBuf> sink;
    private ByteBuf buffer;

    public ByteOutputStream(Consumer<ByteBuf> sink) {
        this(sink, ByteBufAllocator.DEFAULT);
    }

    public ByteOutputStream(Consumer<ByteBuf> sink, ByteBufAllocator allocator) {
        this.allocator = allocator;
        this.buffer = null;
        this.sink = sink;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int nBytes;
        for (int remaining = len - off; remaining > 0; remaining -= nBytes) {
            if (this.buffer == null) {
                this.buffer = this.allocator.directBuffer(4096);
            }
            nBytes = Math.min(remaining, this.buffer.writableBytes());
            this.buffer.writeBytes(b, off, nBytes);
            off += nBytes;
            if (this.buffer.writableBytes() != 0) continue;
            this.sink.accept(this.buffer);
            this.buffer = null;
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.buffer == null) {
            this.buffer = this.allocator.directBuffer(4096);
        }
        this.buffer.writeByte(b);
        if (this.buffer.writableBytes() == 0) {
            this.sink.accept(this.buffer);
            this.buffer = null;
        }
    }

    @Override
    public void flush() {
        if (this.buffer != null && this.buffer.readableBytes() > 0) {
            this.sink.accept(this.buffer);
            this.buffer = null;
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        if (this.buffer != null) {
            this.buffer.release();
            this.buffer = null;
        }
    }
}

