/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.util;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;

public class ByteSeekableChannel
implements SeekableByteChannel {
    private final ByteBuf buffer;
    private final long size;
    private boolean isOpen;

    public ByteSeekableChannel(ByteBuf buffer) {
        this.buffer = buffer;
        buffer.readerIndex(0);
        this.size = buffer.readableBytes();
        this.isOpen = true;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int bytesToRead = Math.min(dst.remaining(), this.buffer.readableBytes());
        this.buffer.readBytes(dst);
        return bytesToRead;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long position() {
        return this.buffer.readerIndex();
    }

    @Override
    public SeekableByteChannel position(long newPosition) {
        if (newPosition < 0L) {
            throw new IllegalArgumentException();
        }
        long position = Math.min(newPosition, this.size);
        this.buffer.readerIndex((int)position);
        return this;
    }

    @Override
    public long size() throws IOException {
        return this.size;
    }

    @Override
    public SeekableByteChannel truncate(long size) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void close() throws IOException {
        this.isOpen = false;
    }
}

