/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.auth.internal;

import org.finos.tracdap.common.auth.internal.AuthConstants;
import org.finos.tracdap.common.auth.internal.UserInfo;
import org.finos.tracdap.common.exception.EAuthorization;

public class AuthHelpers {
    public static UserInfo currentAuthUser() {
        UserInfo authUser = (UserInfo)AuthConstants.TRAC_AUTH_USER_KEY.get();
        if (authUser != null) {
            return authUser;
        }
        throw new EAuthorization("User details are not available");
    }

    public static UserInfo currentUser() {
        UserInfo delegate = (UserInfo)AuthConstants.TRAC_DELEGATE_KEY.get();
        if (delegate != null) {
            return delegate;
        }
        UserInfo authUser = (UserInfo)AuthConstants.TRAC_AUTH_USER_KEY.get();
        if (authUser != null) {
            return authUser;
        }
        throw new EAuthorization("User details are not available");
    }

    public static String printCurrentUser() {
        UserInfo authUser = (UserInfo)AuthConstants.TRAC_AUTH_USER_KEY.get();
        UserInfo delegate = (UserInfo)AuthConstants.TRAC_DELEGATE_KEY.get();
        return AuthHelpers.printCurrentUser(authUser, delegate);
    }

    public static String printCurrentAuthUser() {
        UserInfo authUser = (UserInfo)AuthConstants.TRAC_AUTH_USER_KEY.get();
        return AuthHelpers.printCurrentAuthUser(authUser);
    }

    static String printCurrentAuthUser(UserInfo authUser) {
        return String.format("%s <%s>", authUser.getDisplayName(), authUser.getUserId());
    }

    static String printCurrentUser(UserInfo authUser, UserInfo delegate) {
        if (delegate != null) {
            return String.format("%s <%s> on behalf of %s <%s>", authUser.getDisplayName(), authUser.getUserId(), delegate.getDisplayName(), delegate.getUserId());
        }
        return String.format("%s <%s>", authUser.getDisplayName(), authUser.getUserId());
    }
}

