/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.auth.internal;

import io.grpc.CallCredentials;
import io.grpc.CallOptions;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.stub.AbstractStub;
import java.util.concurrent.Executor;
import org.finos.tracdap.common.auth.internal.AuthConstants;

public class ClientAuthProvider
extends CallCredentials {
    private final String token;

    public static <T extends AbstractStub<T>> T applyIfAvailable(T client, String token) {
        if (token != null && !token.isBlank()) {
            return (T)client.withCallCredentials((CallCredentials)new ClientAuthProvider(token));
        }
        return client;
    }

    public static CallOptions applyIfAvailable(CallOptions callOptions, String token) {
        if (token != null && !token.isBlank()) {
            return callOptions.withCallCredentials((CallCredentials)new ClientAuthProvider(token));
        }
        return callOptions;
    }

    private ClientAuthProvider(String token) {
        this.token = token;
    }

    public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor appExecutor, CallCredentials.MetadataApplier applier) {
        if (this.token == null || this.token.isBlank()) {
            applier.fail(Status.UNAUTHENTICATED);
        } else {
            Metadata authHeaders = new Metadata();
            authHeaders.put(AuthConstants.TRAC_AUTH_TOKEN_KEY, (Object)this.token);
            applier.apply(authHeaders);
        }
    }
}

