/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.auth.internal;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.finos.tracdap.common.auth.internal.InternalCallCredentials;
import org.finos.tracdap.common.auth.internal.JwtProcessor;
import org.finos.tracdap.common.auth.internal.SessionInfo;
import org.finos.tracdap.common.auth.internal.UserInfo;
import org.finos.tracdap.config.AuthenticationConfig;

public class InternalAuthProvider {
    private static final String DEFAULT_SYSTEM_USER_ID = "#trac";
    private static final String DEFAULT_SYSTEM_USER_NAME = "TRAC System";
    private static final Duration DEFAULT_SYSTEM_TICKET_DURATION = Duration.of(5L, ChronoUnit.MINUTES);
    private static final Duration DEFAULT_SYSTEM_TICKET_REFRESH = Duration.of(1L, ChronoUnit.MINUTES);
    private final JwtProcessor tokenProcessor;
    private final UserInfo systemUser;
    private final Duration systemTicketDuration;
    private final Duration systemTicketRefresh;

    public InternalAuthProvider(JwtProcessor tokenProcessor, AuthenticationConfig authConfig) {
        String systemUserId = !authConfig.getSystemUserId().isBlank() ? authConfig.getSystemUserId() : DEFAULT_SYSTEM_USER_ID;
        String systemUserName = !authConfig.getSystemUserName().isBlank() ? authConfig.getSystemUserName() : DEFAULT_SYSTEM_USER_NAME;
        Duration systemTicketDuration = authConfig.getSystemTicketDuration() > 0 ? Duration.of(authConfig.getSystemTicketDuration(), ChronoUnit.SECONDS) : DEFAULT_SYSTEM_TICKET_DURATION;
        Duration systemTicketRefresh = authConfig.getSystemTicketRefresh() > 0 ? Duration.of(authConfig.getSystemTicketRefresh(), ChronoUnit.SECONDS) : DEFAULT_SYSTEM_TICKET_REFRESH;
        UserInfo systemUser = new UserInfo();
        systemUser.setUserId(systemUserId);
        systemUser.setDisplayName(systemUserName);
        this.tokenProcessor = tokenProcessor;
        this.systemUser = systemUser;
        this.systemTicketDuration = systemTicketDuration;
        this.systemTicketRefresh = systemTicketRefresh;
    }

    public InternalCallCredentials createDelegateSession(UserInfo delegate, Duration sessionTimeout) {
        Instant issue = Instant.now();
        Instant expiry = issue.plus(this.systemTicketDuration);
        Instant limit = issue.plus(sessionTimeout);
        SessionInfo session = new SessionInfo();
        session.setUserInfo(this.systemUser);
        session.setDelegate(delegate);
        session.setIssueTime(issue);
        session.setExpiryTime(expiry);
        session.setExpiryLimit(limit);
        return new InternalCallCredentials(this.systemTicketDuration, this.systemTicketRefresh, session, this.tokenProcessor);
    }

    public void setTokenProcessor(InternalCallCredentials callCredentials) {
        callCredentials.setTokenProcessor(this.tokenProcessor);
    }
}

