/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.auth.internal;

import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import org.finos.tracdap.common.auth.internal.AuthConstants;
import org.finos.tracdap.common.auth.internal.AuthHelpers;
import org.finos.tracdap.common.auth.internal.JwtValidator;
import org.finos.tracdap.common.auth.internal.SessionInfo;
import org.finos.tracdap.common.auth.internal.UserInfo;
import org.finos.tracdap.common.exception.EStartup;
import org.finos.tracdap.config.AuthenticationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalAuthValidator
implements ServerInterceptor {
    private static final String AUTH_DISABLED_USER_ID = "no_auth";
    private static final String AUTH_DISABLED_USER_NAME = "Authentication Disabled";
    private static final Logger log = LoggerFactory.getLogger(InternalAuthValidator.class);
    private final AuthenticationConfig authConfig;
    private final JwtValidator jwt;

    public InternalAuthValidator(AuthenticationConfig authConfig, JwtValidator jwt) {
        if (jwt == null && !authConfig.getDisableAuth()) {
            throw new EStartup("Token validator is not available");
        }
        this.authConfig = authConfig;
        this.jwt = jwt;
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        if (this.authConfig.getDisableAuth()) {
            log.warn("AUTHENTICATE: {}() AUTHENTICATION DISABLED", (Object)call.getMethodDescriptor().getBareMethodName());
            UserInfo userInfo = new UserInfo();
            userInfo.setUserId(AUTH_DISABLED_USER_ID);
            userInfo.setDisplayName(AUTH_DISABLED_USER_NAME);
            Context ctx = Context.current().withValue(AuthConstants.TRAC_AUTH_USER_KEY, (Object)userInfo);
            return Contexts.interceptCall((Context)ctx, call, (Metadata)headers, next);
        }
        String token = (String)headers.get(AuthConstants.TRAC_AUTH_TOKEN_KEY);
        if (token == null) {
            String message = "No authentication provided";
            log.error("AUTHENTICATE: {}() [{}] FAILED ", (Object)call.getMethodDescriptor().getBareMethodName(), (Object)message);
            Status status = Status.UNAUTHENTICATED.withDescription(message);
            Metadata trailers = new Metadata();
            call.close(status, trailers);
            return new ServerCall.Listener<ReqT>(){};
        }
        SessionInfo sessionInfo = this.jwt.decodeAndValidate(token);
        if (!sessionInfo.isValid()) {
            log.error("AUTHENTICATE: {}() [{}] FAILED", (Object)call.getMethodDescriptor().getBareMethodName(), (Object)sessionInfo.getErrorMessage());
            Status status = Status.UNAUTHENTICATED.withDescription(sessionInfo.getErrorMessage());
            Metadata trailers = new Metadata();
            call.close(status, trailers);
            return new ServerCall.Listener<ReqT>(){};
        }
        UserInfo userInfo = sessionInfo.getUserInfo();
        UserInfo delegate = sessionInfo.getDelegate();
        if (this.authConfig.getDisableSigning()) {
            log.warn("AUTHENTICATE: {}() [{}] SUCCEEDED WITHOUT VALIDATION", (Object)call.getMethodDescriptor().getBareMethodName(), (Object)AuthHelpers.printCurrentUser(userInfo, delegate));
        } else {
            log.info("AUTHENTICATE: {}() [{}] SUCCEEDED", (Object)call.getMethodDescriptor().getBareMethodName(), (Object)AuthHelpers.printCurrentUser(userInfo, delegate));
        }
        Context ctx = Context.current().withValue(AuthConstants.TRAC_AUTH_USER_KEY, (Object)userInfo).withValue(AuthConstants.TRAC_DELEGATE_KEY, (Object)delegate);
        return Contexts.interceptCall((Context)ctx, call, (Metadata)headers, next);
    }
}

