/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.auth.internal;

import io.grpc.CallCredentials;
import io.grpc.Metadata;
import io.grpc.Status;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.Executor;
import org.finos.tracdap.common.auth.internal.AuthConstants;
import org.finos.tracdap.common.auth.internal.JwtProcessor;
import org.finos.tracdap.common.auth.internal.SessionInfo;

public class InternalCallCredentials
extends CallCredentials
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Duration systemTicketDuration;
    private final Duration systemTicketRefresh;
    private final SessionInfo session;
    private String token;
    private Instant refresh;
    private transient JwtProcessor tokenProcessor;

    InternalCallCredentials(Duration systemTicketDuration, Duration systemTicketRefresh, SessionInfo session, JwtProcessor tokenProcessor) {
        this.systemTicketDuration = systemTicketDuration;
        this.systemTicketRefresh = systemTicketRefresh;
        this.session = session;
        this.tokenProcessor = tokenProcessor;
    }

    void setTokenProcessor(JwtProcessor tokenProcessor) {
        this.tokenProcessor = tokenProcessor;
    }

    public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor appExecutor, CallCredentials.MetadataApplier applier) {
        if (this.tokenProcessor == null) {
            applier.apply(new Metadata());
            return;
        }
        Instant now = Instant.now();
        if (now.isAfter(this.session.getExpiryLimit())) {
            applier.fail(Status.UNAUTHENTICATED.withDescription("Session timed out"));
            return;
        }
        if (this.token == null || now.isAfter(this.refresh)) {
            this.token = this.regenerateToken(now);
            this.refresh = now.plus(this.systemTicketRefresh);
        }
        Metadata authHeaders = new Metadata();
        authHeaders.put(AuthConstants.TRAC_AUTH_TOKEN_KEY, (Object)this.token);
        applier.apply(authHeaders);
    }

    private String regenerateToken(Instant refreshTime) {
        this.session.setIssueTime(refreshTime);
        Instant expiryUnlimited = refreshTime.plus(this.systemTicketDuration);
        if (expiryUnlimited.isAfter(this.session.getExpiryLimit())) {
            this.session.setExpiryTime(expiryUnlimited);
        } else {
            this.session.setExpiryTime(this.session.getExpiryLimit());
        }
        return this.tokenProcessor.encodeToken(this.session);
    }
}

