/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.auth.internal;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.algorithms.Algorithm;
import java.util.Map;
import org.finos.tracdap.common.auth.internal.JwtValidator;
import org.finos.tracdap.common.auth.internal.SessionInfo;
import org.finos.tracdap.config.AuthenticationConfig;

public class JwtProcessor
extends JwtValidator {
    JwtProcessor(AuthenticationConfig authConfig, Algorithm algorithm) {
        super(authConfig, algorithm);
    }

    public String encodeToken(SessionInfo session) {
        Map<String, Algorithm> header = Map.of("typ", "jwt", "alg", this.algorithm);
        JWTCreator.Builder jwt = JWT.create().withHeader(header).withSubject(session.getUserInfo().getUserId()).withIssuer(this.issuer).withIssuedAt(session.getIssueTime()).withExpiresAt(session.getExpiryTime()).withClaim("limit", session.getExpiryLimit()).withClaim("name", session.getUserInfo().getDisplayName());
        if (session.getDelegate() != null) {
            jwt.withClaim("delegate", session.getDelegate().getUserId());
            jwt.withClaim("delegateName", session.getDelegate().getDisplayName());
        }
        return jwt.sign(this.algorithm).trim();
    }
}

