/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.auth.internal;

import com.auth0.jwt.algorithms.Algorithm;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import org.finos.tracdap.common.auth.internal.JwtProcessor;
import org.finos.tracdap.common.auth.internal.JwtValidator;
import org.finos.tracdap.common.config.ConfigManager;
import org.finos.tracdap.common.exception.EStartup;
import org.finos.tracdap.common.exception.EUnexpected;
import org.finos.tracdap.config.AuthenticationConfig;
import org.finos.tracdap.config.PlatformConfig;
import org.finos.tracdap.config.PlatformInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtSetup {
    private static final Logger log = LoggerFactory.getLogger(JwtSetup.class);

    public static JwtProcessor createProcessor(PlatformConfig platformConfig, ConfigManager configManager) {
        AuthenticationConfig authConfig = platformConfig.getAuthentication();
        PlatformInfo platformInfo = platformConfig.getPlatformInfo();
        if (configManager.hasSecret("trac_auth_public_key") && configManager.hasSecret("trac_auth_private_key")) {
            PublicKey publicKey = configManager.loadPublicKey("trac_auth_public_key");
            PrivateKey privateKey = configManager.loadPrivateKey("trac_auth_private_key");
            KeyPair keyPair = new KeyPair(publicKey, privateKey);
            return JwtSetup.createProcessor(authConfig, platformInfo, keyPair);
        }
        return JwtSetup.createProcessor(authConfig, platformInfo, null);
    }

    public static JwtValidator createValidator(PlatformConfig platformConfig, ConfigManager configManager) {
        return JwtSetup.createValidator(platformConfig.getAuthentication(), platformConfig.getPlatformInfo(), configManager);
    }

    private static JwtValidator createValidator(AuthenticationConfig authConfig, PlatformInfo platformInfo, ConfigManager configManager) {
        if (configManager.hasSecret("trac_auth_public_key")) {
            PublicKey publicKey = configManager.loadPublicKey("trac_auth_public_key");
            return JwtSetup.createValidator(authConfig, platformInfo, publicKey);
        }
        return JwtSetup.createValidator(authConfig, platformInfo, (PublicKey)null);
    }

    public static JwtProcessor createProcessor(AuthenticationConfig authConfig, PlatformInfo platformInfo, KeyPair keyPair) {
        JwtSetup.checkProduction(authConfig, platformInfo);
        if (authConfig.getDisableAuth()) {
            log.warn("!!!!! AUTHENTICATION IS DISABLED (do not use this setting in production)");
            return null;
        }
        if (authConfig.getDisableSigning()) {
            log.warn("!!!!! SIGNATURE VALIDATION IS DISABLED (do not use this setting in production)");
            return new JwtProcessor(authConfig, Algorithm.none());
        }
        if (keyPair == null) {
            String error = "Root authentication keys are not available, the service will not start";
            log.error(error);
            throw new EStartup(error);
        }
        Algorithm algorithm = JwtSetup.chooseAlgorithm(keyPair);
        return new JwtProcessor(authConfig, algorithm);
    }

    public static JwtValidator createValidator(AuthenticationConfig authConfig, PlatformInfo platformInfo, PublicKey publicKey) {
        JwtSetup.checkProduction(authConfig, platformInfo);
        if (authConfig.getDisableAuth()) {
            log.warn("!!!!! AUTHENTICATION IS DISABLED (do not use this setting in production)");
            return null;
        }
        if (authConfig.getDisableSigning()) {
            log.warn("!!!!! SIGNATURE VALIDATION IS DISABLED (do not use this setting in production)");
            return new JwtValidator(authConfig, Algorithm.none());
        }
        if (publicKey == null) {
            String error = "Root authentication keys are not available, the service will not start";
            log.error(error);
            throw new EStartup(error);
        }
        Algorithm algorithm = JwtSetup.chooseAlgorithm(publicKey);
        return new JwtValidator(authConfig, algorithm);
    }

    private static void checkProduction(AuthenticationConfig authConfig, PlatformInfo platformInfo) {
        if (platformInfo.getProduction() && (authConfig.getDisableAuth() || authConfig.getDisableSigning())) {
            String message = String.format("Authentication and token signing must be enabled in production environment [%s]", platformInfo.getEnvironment());
            log.error(message);
            throw new EStartup(message);
        }
    }

    private static Algorithm chooseAlgorithm(PublicKey publicKey) {
        if (publicKey == null) {
            throw new EUnexpected();
        }
        KeyPair keyPair = new KeyPair(publicKey, null);
        return JwtSetup.chooseAlgorithm(keyPair);
    }

    private static Algorithm chooseAlgorithm(KeyPair keyPair) {
        if (keyPair == null) {
            throw new EUnexpected();
        }
        String keyAlgo = keyPair.getPublic().getAlgorithm();
        int keySize = keyPair.getPublic().getEncoded().length * 8;
        if (keyAlgo.equals("EC")) {
            if (keySize >= 512) {
                return Algorithm.ECDSA512((ECPublicKey)((ECPublicKey)keyPair.getPublic()), (ECPrivateKey)((ECPrivateKey)keyPair.getPrivate()));
            }
            if (keySize >= 384) {
                return Algorithm.ECDSA384((ECPublicKey)((ECPublicKey)keyPair.getPublic()), (ECPrivateKey)((ECPrivateKey)keyPair.getPrivate()));
            }
            if (keySize >= 256) {
                return Algorithm.ECDSA256((ECPublicKey)((ECPublicKey)keyPair.getPublic()), (ECPrivateKey)((ECPrivateKey)keyPair.getPrivate()));
            }
        }
        if (keyAlgo.equals("RSA")) {
            if (keySize >= 3072) {
                return Algorithm.RSA512((RSAPublicKey)((RSAPublicKey)keyPair.getPublic()), (RSAPrivateKey)((RSAPrivateKey)keyPair.getPrivate()));
            }
            if (keySize >= 2048) {
                return Algorithm.RSA384((RSAPublicKey)((RSAPublicKey)keyPair.getPublic()), (RSAPrivateKey)((RSAPrivateKey)keyPair.getPrivate()));
            }
            if (keySize >= 1024) {
                return Algorithm.RSA256((RSAPublicKey)((RSAPublicKey)keyPair.getPublic()), (RSAPrivateKey)((RSAPrivateKey)keyPair.getPrivate()));
            }
        }
        String message = String.format("Root authentication key uses an unsupported algorith [algorithM: %s, key size: %s]", keyAlgo, keySize);
        throw new EStartup(message);
    }
}

