/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.auth.internal;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.time.Instant;
import org.finos.tracdap.common.auth.internal.SessionInfo;
import org.finos.tracdap.common.auth.internal.UserInfo;
import org.finos.tracdap.common.config.ConfigDefaults;
import org.finos.tracdap.config.AuthenticationConfig;

public class JwtValidator {
    protected static final String JWT_NAME_CLAIM = "name";
    protected static final String JWT_LIMIT_CLAIM = "limit";
    protected static final String JWT_DELEGATE_ID_CLAIM = "delegate";
    protected static final String JWT_DELEGATE_NAME_CLAIM = "delegateName";
    protected final Algorithm algorithm;
    protected final String issuer;
    protected final int expiry;
    private final JWTVerifier verifier;

    JwtValidator(AuthenticationConfig authConfig, Algorithm algorithm) {
        this.algorithm = algorithm;
        this.issuer = authConfig.getJwtIssuer();
        this.expiry = ConfigDefaults.readOrDefault(authConfig.getJwtExpiry(), 3600);
        this.verifier = JWT.require((Algorithm)algorithm).withIssuer(this.issuer).build();
    }

    public SessionInfo decodeAndValidate(String token) {
        try {
            DecodedJWT jwt = this.verifier.verify(token);
            Claim userId = jwt.getClaim("sub");
            Claim displayName = jwt.getClaim(JWT_NAME_CLAIM);
            Claim issueTimeStr = jwt.getClaim("iat");
            Claim expiryTimeStr = jwt.getClaim("exp");
            Claim expiryLimitStr = jwt.getClaim(JWT_LIMIT_CLAIM);
            if (userId.isMissing() || issueTimeStr.isMissing() || expiryTimeStr.isMissing() || expiryLimitStr.isMissing()) {
                SessionInfo sessionInfo = new SessionInfo();
                sessionInfo.setValid(false);
                sessionInfo.setErrorMessage("Authentication failed: Missing required details");
                return sessionInfo;
            }
            UserInfo userInfo = new UserInfo();
            userInfo.setUserId(userId.asString());
            userInfo.setDisplayName(displayName.isMissing() ? userId.asString() : displayName.asString());
            Instant issueTime = Instant.ofEpochSecond(issueTimeStr.asLong());
            Instant expiryTime = Instant.ofEpochSecond(expiryTimeStr.asLong());
            Instant expiryLimit = Instant.ofEpochSecond(expiryLimitStr.asLong());
            SessionInfo sessionInfo = new SessionInfo();
            sessionInfo.setUserInfo(userInfo);
            sessionInfo.setIssueTime(issueTime);
            sessionInfo.setExpiryTime(expiryTime);
            sessionInfo.setExpiryLimit(expiryLimit);
            sessionInfo.setValid(true);
            Claim delegateIdClaim = jwt.getClaim(JWT_DELEGATE_ID_CLAIM);
            Claim delegateNameClaim = jwt.getClaim(JWT_DELEGATE_NAME_CLAIM);
            if (!delegateIdClaim.isMissing()) {
                UserInfo delegate = new UserInfo();
                delegate.setUserId(delegateIdClaim.asString());
                delegate.setDisplayName(delegateNameClaim.asString());
                sessionInfo.setDelegate(delegate);
            }
            return sessionInfo;
        }
        catch (JWTVerificationException | NumberFormatException e) {
            String message = String.format("Session is not valid: %s", e.getMessage());
            SessionInfo sessionInfo = new SessionInfo();
            sessionInfo.setValid(false);
            sessionInfo.setErrorMessage(message);
            return sessionInfo;
        }
    }
}

