/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.config;

import java.util.Properties;
import org.finos.tracdap.common.exception.EStartup;

public class ConfigHelpers {
    private static final String BOOLEAN_TRUE = Boolean.TRUE.toString();
    private static final String BOOLEAN_FALSE = Boolean.FALSE.toString();

    public static boolean optionalBoolean(String context, Properties properties, String key, boolean defaultValue) {
        String rawValue = properties.getProperty(key);
        if (rawValue == null || rawValue.trim().equals("")) {
            return defaultValue;
        }
        return ConfigHelpers.checkBoolean(context, key, rawValue);
    }

    private static boolean checkBoolean(String context, String key, String rawValue) {
        if (rawValue == null || rawValue.trim().equals("")) {
            String message = String.format("Missing required property [%s] for [%s]", key, context);
            throw new EStartup(message);
        }
        if (rawValue.equalsIgnoreCase(BOOLEAN_TRUE)) {
            return true;
        }
        if (rawValue.equalsIgnoreCase(BOOLEAN_FALSE)) {
            return false;
        }
        String message = String.format("Invalid boolean value for property [%s] in [%s]", key, context);
        throw new EStartup(message);
    }
}

