/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.config.local;

import java.util.List;
import java.util.Properties;
import org.finos.tracdap.common.config.IConfigLoader;
import org.finos.tracdap.common.config.ISecretLoader;
import org.finos.tracdap.common.config.local.JksSecretLoader;
import org.finos.tracdap.common.config.local.LocalConfigLoader;
import org.finos.tracdap.common.exception.EPluginNotAvailable;
import org.finos.tracdap.common.plugin.PluginServiceInfo;
import org.finos.tracdap.common.plugin.TracPlugin;

public class LocalConfigPlugin
extends TracPlugin {
    private static final String PLUGIN_NAME = "LOCAL_CONFIG";
    private static final String FILE_LOADER = "FILE_LOADER";
    private static final String JKS_SECRET_LOADER = "JKS_SECRET_LOADER";
    private static final List<PluginServiceInfo> serviceInfo = List.of(new PluginServiceInfo(IConfigLoader.class, "FILE_LOADER", List.of("LOCAL", "file")), new PluginServiceInfo(ISecretLoader.class, "JKS_SECRET_LOADER", List.of("PKCS12", "JCEKS")));

    @Override
    public String pluginName() {
        return PLUGIN_NAME;
    }

    @Override
    public List<PluginServiceInfo> serviceInfo() {
        return serviceInfo;
    }

    @Override
    protected <T> T createConfigService(String serviceName, Properties properties) {
        if (serviceName.equals(FILE_LOADER)) {
            return (T)new LocalConfigLoader();
        }
        if (serviceName.equals(JKS_SECRET_LOADER)) {
            return (T)new JksSecretLoader(properties);
        }
        String message = String.format("Plugin [%s] does not support the service [%s]", this.pluginName(), serviceName);
        throw new EPluginNotAvailable(message);
    }
}

