/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.grpc;

import com.google.protobuf.MessageLite;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.MethodDescriptor;

public class CompressionClientInterceptor
implements ClientInterceptor {
    public static final String COMPRESSION_TYPE = "gzip";
    public static final int COMPRESSION_THRESHOLD = 65336;

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        ClientCall nextCall = next.newCall(method, callOptions);
        return new CompressionClientCall(nextCall);
    }

    private static class CompressionClientCall<ReqT, RespT>
    extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
        public CompressionClientCall(ClientCall<ReqT, RespT> delegate) {
            super(delegate);
        }

        public void sendMessage(ReqT message) {
            MessageLite msg = (MessageLite)message;
            if (msg.getSerializedSize() > 65336) {
                this.delegate().setMessageCompression(true);
            }
            this.delegate().sendMessage(message);
        }
    }
}

