/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.grpc;

import com.google.protobuf.MessageLite;
import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;

public class CompressionServerInterceptor
implements ServerInterceptor {
    public static final String COMPRESSION_TYPE = "gzip";
    public static final int COMPRESSION_THRESHOLD = 65336;

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        call.setCompression(COMPRESSION_TYPE);
        CompressionServerCall<ReqT, RespT> compressionCall = new CompressionServerCall<ReqT, RespT>(call);
        return next.startCall(compressionCall, headers);
    }

    private static class CompressionServerCall<ReqT, RespT>
    extends ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT> {
        public CompressionServerCall(ServerCall<ReqT, RespT> delegate) {
            super(delegate);
        }

        public void sendMessage(RespT message) {
            MessageLite msg = (MessageLite)message;
            if (msg != null) {
                this.delegate().setMessageCompression(msg.getSerializedSize() > 65336);
            }
            this.delegate().sendMessage(message);
        }
    }
}

