/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.grpc;

import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import org.finos.tracdap.common.grpc.GrpcErrorMapping;

public class ErrorMappingInterceptor
implements ServerInterceptor {
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        ErrorMappingServerCall<ReqT, RespT> errorHandler = new ErrorMappingServerCall<ReqT, RespT>(call);
        return next.startCall(errorHandler, headers);
    }

    private static class ErrorMappingServerCall<ReqT, RespT>
    extends ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT> {
        protected ErrorMappingServerCall(ServerCall<ReqT, RespT> delegate) {
            super(delegate);
        }

        public void close(Status status, Metadata trailers) {
            if (status.isOk()) {
                this.delegate().close(status, trailers);
            } else if (status.getCause() != null) {
                Status mappedStatus = GrpcErrorMapping.processErrorToStatus(status.getCause());
                this.delegate().close(mappedStatus, trailers);
            } else {
                Status mappedStatus = GrpcErrorMapping.processErrorToStatus((Throwable)status.asRuntimeException());
                this.delegate().close(mappedStatus, trailers);
            }
        }
    }
}

