/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.grpc;

import io.grpc.stub.StreamObserver;
import java.util.function.Function;

public class GrpcServerWrap {
    public <TRequest, TResponse> void unaryCall(TRequest request, StreamObserver<TResponse> responseObserver, Function<TRequest, TResponse> methodImpl) {
        try {
            TResponse result = methodImpl.apply(request);
            this.handleResult(responseObserver, result, null);
        }
        catch (Exception error) {
            this.handleResult(responseObserver, null, error);
        }
    }

    private <TResponse> void handleResult(StreamObserver<TResponse> responseObserver, TResponse result, Throwable error) {
        if (error == null) {
            responseObserver.onNext(result);
            responseObserver.onCompleted();
        } else {
            responseObserver.onError(error);
        }
    }
}

