/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.grpc;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingClientInterceptor
implements ClientInterceptor {
    private final Logger log;

    public LoggingClientInterceptor(Class<?> serviceClass) {
        this.log = LoggerFactory.getLogger(serviceClass);
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        ClientCall nextCall = next.newCall(method, callOptions);
        String methodName = this.methodDisplayName(method);
        return new LoggingClientCall(nextCall, methodName, method.getType());
    }

    private String methodDisplayName(MethodDescriptor<?, ?> method) {
        String serviceName = method.getServiceName();
        String shortServiceName = serviceName == null ? null : serviceName.substring(serviceName.lastIndexOf(".") + 1);
        String methodName = method.getBareMethodName();
        return String.format("%s.%s()", shortServiceName, methodName);
    }

    private class LoggingClientCall<ReqT, RespT>
    extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
        private final String methodName;
        private final MethodDescriptor.MethodType methodType;

        LoggingClientCall(ClientCall<ReqT, RespT> delegate, String methodName, MethodDescriptor.MethodType methodType) {
            super(delegate);
            this.methodName = methodName;
            this.methodType = methodType;
        }

        public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
            if (this.methodType == MethodDescriptor.MethodType.UNARY) {
                LoggingClientInterceptor.this.log.info("CLIENT CALL START: {}", (Object)this.methodName);
            } else {
                LoggingClientInterceptor.this.log.info("CLIENT CALL START: {} ({})", (Object)this.methodName, (Object)this.methodType);
            }
            LoggingClientCallListener<RespT> loggingResponseListener = new LoggingClientCallListener<RespT>(responseListener, this.methodName);
            this.delegate().start(loggingResponseListener, headers);
        }
    }

    private class LoggingClientCallListener<RespT>
    extends ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT> {
        private final String methodName;

        LoggingClientCallListener(ClientCall.Listener<RespT> delegate, String methodName) {
            super(delegate);
            this.methodName = methodName;
        }

        public void onClose(Status status, Metadata trailers) {
            if (status.isOk()) {
                LoggingClientInterceptor.this.log.info("CLIENT CALL SUCCEEDED: {}", (Object)this.methodName);
            } else if (status.getCause() != null) {
                LoggingClientInterceptor.this.log.error("CLIENT CALL FAILED: {} {}", new Object[]{this.methodName, status.getDescription(), status.getCause()});
            } else {
                LoggingClientInterceptor.this.log.error("CLIENT CALL FAILED: {} {}", (Object)this.methodName, (Object)status.getDescription());
                LoggingClientInterceptor.this.log.error("(stack trace not available)");
            }
            this.delegate().onClose(status, trailers);
        }
    }
}

