/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.grpc;

import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import org.finos.tracdap.common.auth.internal.AuthHelpers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingServerInterceptor
implements ServerInterceptor {
    private final Logger log;

    public LoggingServerInterceptor(Class<?> apiClass) {
        this.log = LoggerFactory.getLogger(apiClass);
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        MethodDescriptor method = call.getMethodDescriptor();
        if (method.getType() == MethodDescriptor.MethodType.UNARY) {
            this.log.info("API CALL START: {}() [{}]", (Object)method.getBareMethodName(), (Object)AuthHelpers.printCurrentUser());
        } else {
            this.log.info("API CALL START: {}() [{}] ({})", new Object[]{method.getBareMethodName(), AuthHelpers.printCurrentUser(), method.getType()});
        }
        LoggingServerCall<ReqT, RespT> loggingCall = new LoggingServerCall<ReqT, RespT>(call);
        return next.startCall(loggingCall, headers);
    }

    private class LoggingServerCall<ReqT, RespT>
    extends ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT> {
        public LoggingServerCall(ServerCall<ReqT, RespT> delegate) {
            super(delegate);
        }

        public void close(Status status, Metadata trailers) {
            MethodDescriptor method = this.getMethodDescriptor();
            if (status.isOk()) {
                LoggingServerInterceptor.this.log.info("API CALL SUCCEEDED: {}()", (Object)method.getBareMethodName());
            } else if (status.getCause() != null) {
                LoggingServerInterceptor.this.log.error("API CALL FAILED: {}() {}", new Object[]{method.getBareMethodName(), status.getDescription(), status.getCause()});
            } else {
                LoggingServerInterceptor.this.log.error("API CALL FAILED: {}() {}", (Object)method.getBareMethodName(), (Object)status.getDescription());
                LoggingServerInterceptor.this.log.error("(stack trace not available)");
            }
            this.delegate().close(status, trailers);
        }
    }
}

