/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.metadata;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import java.util.stream.Collectors;
import org.finos.tracdap.common.exception.EUnexpected;
import org.finos.tracdap.common.exception.EValidationGap;
import org.finos.tracdap.common.metadata.TypeSystem;
import org.finos.tracdap.metadata.ArrayValue;
import org.finos.tracdap.metadata.BasicType;
import org.finos.tracdap.metadata.DateValue;
import org.finos.tracdap.metadata.DatetimeValue;
import org.finos.tracdap.metadata.DecimalValue;
import org.finos.tracdap.metadata.TypeDescriptor;
import org.finos.tracdap.metadata.Value;

public class MetadataCodec {
    public static final DecimalFormat DECIMAL_FORMAT;
    public static final DateTimeFormatter ISO_DATE_FORMAT;
    public static final DateTimeFormatter ISO_DATETIME_FORMAT;
    public static final DateTimeFormatter ISO_DATETIME_NO_ZONE_FORMAT;
    public static final DateTimeFormatter ISO_DATETIME_INPUT_FORMAT;
    public static final DateTimeFormatter ISO_DATETIME_INPUT_NO_ZONE_FORMAT;

    public static Value encodeNativeObject(Object value) {
        Class<?> clazz = value.getClass();
        return MetadataCodec.encodeNativeObject(value, clazz);
    }

    public static Value encodeNativeObject(Object value, Class<?> clazz) {
        if (Boolean.class.equals(clazz)) {
            return MetadataCodec.encodeValue((Boolean)value);
        }
        if (Long.class.equals(clazz)) {
            return MetadataCodec.encodeValue((Long)value);
        }
        if (Integer.class.equals(clazz)) {
            return MetadataCodec.encodeValue((Integer)value);
        }
        if (Double.class.equals(clazz)) {
            return MetadataCodec.encodeValue((Double)value);
        }
        if (Float.class.equals(clazz)) {
            return MetadataCodec.encodeValue(((Float)value).floatValue());
        }
        if (String.class.equals(clazz)) {
            return MetadataCodec.encodeValue((String)value);
        }
        if (BigDecimal.class.equals(clazz)) {
            return MetadataCodec.encodeValue((BigDecimal)value);
        }
        if (LocalDate.class.equals(clazz)) {
            return MetadataCodec.encodeValue((LocalDate)value);
        }
        if (OffsetDateTime.class.equals(clazz)) {
            return MetadataCodec.encodeValue((OffsetDateTime)value);
        }
        String message = "Cannot encode value with Java class [%s]";
        throw new IllegalArgumentException(String.format(message, clazz.getName()));
    }

    public static Value encodeValue(Object value, TypeDescriptor descriptor) {
        BasicType basicType = TypeSystem.basicType(descriptor);
        if (TypeSystem.isPrimitive(basicType)) {
            return MetadataCodec.encodeValue(value, basicType);
        }
        if (basicType == BasicType.ARRAY) {
            if (value instanceof List) {
                return MetadataCodec.encodeArrayValue((List)value, descriptor.getArrayType());
            }
            throw new IllegalArgumentException("Object does not match type");
        }
        String message = "Cannot encode value with type [%s]";
        throw new IllegalArgumentException(String.format(message, basicType.name()));
    }

    public static Value encodeValue(Object value, BasicType basicType) {
        BasicType typeCheck = TypeSystem.basicType(value);
        if (typeCheck != basicType) {
            throw new IllegalArgumentException("Object does not match type");
        }
        switch (basicType) {
            case BOOLEAN: {
                return MetadataCodec.encodeValue((Boolean)value);
            }
            case INTEGER: {
                if (value instanceof Integer) {
                    return MetadataCodec.encodeValue((Integer)value);
                }
                return MetadataCodec.encodeValue((Long)value);
            }
            case FLOAT: {
                if (value instanceof Float) {
                    return MetadataCodec.encodeValue(((Float)value).floatValue());
                }
                return MetadataCodec.encodeValue((Double)value);
            }
            case STRING: {
                return MetadataCodec.encodeValue((String)value);
            }
            case DECIMAL: {
                return MetadataCodec.encodeValue((BigDecimal)value);
            }
            case DATE: {
                return MetadataCodec.encodeValue((LocalDate)value);
            }
            case DATETIME: {
                return MetadataCodec.encodeValue((OffsetDateTime)value);
            }
        }
        String message = "Cannot encode value with type [%s]";
        throw new IllegalArgumentException(String.format(message, basicType.name()));
    }

    public static Value encodeValue(boolean booleanValue) {
        return Value.newBuilder().setType(TypeSystem.descriptor(BasicType.BOOLEAN)).setBooleanValue(booleanValue).build();
    }

    public static Value encodeValue(int integerValue) {
        return Value.newBuilder().setType(TypeSystem.descriptor(BasicType.INTEGER)).setIntegerValue((long)integerValue).build();
    }

    public static Value encodeValue(long integerValue) {
        return Value.newBuilder().setType(TypeSystem.descriptor(BasicType.INTEGER)).setIntegerValue(integerValue).build();
    }

    public static Value encodeValue(float floatValue) {
        return Value.newBuilder().setType(TypeSystem.descriptor(BasicType.FLOAT)).setFloatValue((double)floatValue).build();
    }

    public static Value encodeValue(double floatValue) {
        return Value.newBuilder().setType(TypeSystem.descriptor(BasicType.FLOAT)).setFloatValue(floatValue).build();
    }

    public static Value encodeValue(String stringValue) {
        return Value.newBuilder().setType(TypeSystem.descriptor(BasicType.STRING)).setStringValue(stringValue).build();
    }

    public static Value encodeValue(BigDecimal decimalValue) {
        String decimalString = decimalValue.toPlainString();
        return Value.newBuilder().setType(TypeSystem.descriptor(BasicType.DECIMAL)).setDecimalValue(DecimalValue.newBuilder().setDecimal(decimalString)).build();
    }

    public static Value encodeValue(LocalDate dateValue) {
        return Value.newBuilder().setType(TypeSystem.descriptor(BasicType.DATE)).setDateValue(MetadataCodec.encodeDate(dateValue)).build();
    }

    public static Value encodeValue(OffsetDateTime datetimeValue) {
        return Value.newBuilder().setType(TypeSystem.descriptor(BasicType.DATETIME)).setDatetimeValue(MetadataCodec.encodeDatetime(datetimeValue)).build();
    }

    public static DateValue encodeDate(LocalDate date) {
        String isoDate = ISO_DATE_FORMAT.format(date);
        return DateValue.newBuilder().setIsoDate(isoDate).build();
    }

    public static DatetimeValue encodeDatetime(OffsetDateTime datetime) {
        String isoDatetime = ISO_DATETIME_FORMAT.format(datetime);
        return DatetimeValue.newBuilder().setIsoDatetime(isoDatetime).build();
    }

    public static DatetimeValue encodeDatetime(Instant datetime) {
        String isoDatetime = ISO_DATETIME_FORMAT.format(datetime.atOffset(ZoneOffset.UTC));
        return DatetimeValue.newBuilder().setIsoDatetime(isoDatetime).build();
    }

    public static <T> Value encodeArrayValue(List<T> arrayValue, TypeDescriptor arrayType) {
        ArrayValue.Builder encodedArray = ArrayValue.newBuilder().addAllItems((Iterable)arrayValue.stream().map(x -> MetadataCodec.encodeValue(x, arrayType)).collect(Collectors.toList()));
        TypeDescriptor.Builder typeDescriptor = TypeDescriptor.newBuilder().setBasicType(BasicType.ARRAY).setArrayType(arrayType);
        return Value.newBuilder().setType(typeDescriptor).setArrayValue(encodedArray).build();
    }

    public static <T> Value encodeArrayValue(List<T> arrayValue, Class<T> arrayClass) {
        TypeDescriptor arrayType = TypeSystem.descriptor(arrayClass);
        return MetadataCodec.encodeArrayValue(arrayValue, arrayType);
    }

    public static Object decodeValue(Value value) {
        BasicType basicType = TypeSystem.basicType(value);
        switch (basicType) {
            case BOOLEAN: {
                return value.getBooleanValue();
            }
            case INTEGER: {
                return value.getIntegerValue();
            }
            case FLOAT: {
                return value.getFloatValue();
            }
            case STRING: {
                return value.getStringValue();
            }
            case DECIMAL: {
                return MetadataCodec.decodeDecimalValue(value);
            }
            case DATE: {
                return MetadataCodec.decodeDateValue(value);
            }
            case DATETIME: {
                return MetadataCodec.decodeDateTimeValue(value);
            }
        }
        String message = "Cannot decode value of type [%s]";
        throw new IllegalArgumentException(String.format(message, basicType.name()));
    }

    public static boolean decodeBooleanValue(Value value) {
        if (TypeSystem.basicType(value) != BasicType.BOOLEAN) {
            throw new IllegalArgumentException("Value is not a boolean");
        }
        return value.getBooleanValue();
    }

    public static long decodeIntegerValue(Value value) {
        if (TypeSystem.basicType(value) != BasicType.INTEGER) {
            throw new IllegalArgumentException("Value is not an integer");
        }
        return value.getIntegerValue();
    }

    public static double decodeFloatValue(Value value) {
        if (TypeSystem.basicType(value) != BasicType.FLOAT) {
            throw new IllegalArgumentException("Value is not a float");
        }
        return value.getFloatValue();
    }

    public static String decodeStringValue(Value value) {
        if (TypeSystem.basicType(value) != BasicType.STRING) {
            throw new IllegalArgumentException("Value is not a string");
        }
        return value.getStringValue();
    }

    public static BigDecimal decodeDecimalValue(Value value) {
        if (TypeSystem.basicType(value) != BasicType.DECIMAL) {
            throw new IllegalArgumentException("Value is not a decimal");
        }
        return new BigDecimal(value.getDecimalValue().getDecimal());
    }

    public static LocalDate decodeDateValue(Value value) {
        if (TypeSystem.basicType(value) != BasicType.DATE) {
            throw new IllegalArgumentException("Value is not a date");
        }
        return MetadataCodec.decodeDate(value.getDateValue());
    }

    public static OffsetDateTime decodeDateTimeValue(Value value) {
        if (TypeSystem.basicType(value) != BasicType.DATETIME) {
            throw new IllegalArgumentException("Value is not a date-time");
        }
        return MetadataCodec.decodeDatetime(value.getDatetimeValue());
    }

    public static List<?> decodeArrayValue(Value value) {
        if (TypeSystem.basicType(value) != BasicType.ARRAY) {
            throw new IllegalArgumentException("Value is not an array");
        }
        return value.getArrayValue().getItemsList().stream().map(MetadataCodec::decodeValue).collect(Collectors.toList());
    }

    public static LocalDate decodeDate(DateValue date) {
        return LocalDate.from(ISO_DATE_FORMAT.parse(date.getIsoDate()));
    }

    public static OffsetDateTime decodeDatetime(DatetimeValue datetime) {
        try {
            TemporalAccessor parseResult = ISO_DATETIME_INPUT_FORMAT.parseBest(datetime.getIsoDatetime(), OffsetDateTime::from, LocalDateTime::from);
            if (parseResult instanceof OffsetDateTime) {
                return (OffsetDateTime)parseResult;
            }
            if (parseResult instanceof LocalDateTime) {
                return ((LocalDateTime)parseResult).atOffset(ZoneOffset.UTC);
            }
            throw new EUnexpected();
        }
        catch (DateTimeParseException e) {
            throw new EValidationGap(e.getMessage(), e);
        }
    }

    static {
        ISO_DATE_FORMAT = DateTimeFormatter.ISO_LOCAL_DATE;
        ISO_DATETIME_FORMAT = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss").appendFraction(ChronoField.MICRO_OF_SECOND, 3, 3, true).appendOffsetId().toFormatter();
        ISO_DATETIME_NO_ZONE_FORMAT = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss").appendFraction(ChronoField.MILLI_OF_SECOND, 3, 3, true).toFormatter();
        ISO_DATETIME_INPUT_FORMAT = new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().appendPattern("yyyy-MM-dd'T'HH:mm:ss").appendFraction(ChronoField.MICRO_OF_SECOND, 0, 9, true).appendOffsetId().toFormatter();
        ISO_DATETIME_INPUT_NO_ZONE_FORMAT = new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().appendPattern("yyyy-MM-dd'T'HH:mm:ss").appendFraction(ChronoField.MICRO_OF_SECOND, 0, 9, true).toFormatter();
        DECIMAL_FORMAT = new DecimalFormat();
        DECIMAL_FORMAT.setParseBigDecimal(true);
    }
}

