/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.plugin;

import java.util.Objects;
import javax.annotation.Nonnull;

class PluginKey {
    private final Class<?> service;
    private final String protocol;

    public PluginKey(@Nonnull Class<?> service, @Nonnull String protocol) {
        this.service = service;
        this.protocol = protocol.toLowerCase();
    }

    public Class<?> serviceClass() {
        return this.service;
    }

    public String protocol() {
        return this.protocol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginKey pluginKey = (PluginKey)o;
        return this.service.equals(pluginKey.service) && this.protocol.equals(pluginKey.protocol);
    }

    public int hashCode() {
        return Objects.hash(this.service, this.protocol);
    }
}

