/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.finos.tracdap.common.config.ConfigManager;
import org.finos.tracdap.common.exception.EPluginNotAvailable;
import org.finos.tracdap.common.exception.EUnexpected;
import org.finos.tracdap.common.plugin.IPluginManager;
import org.finos.tracdap.common.plugin.ITracPlugin;
import org.finos.tracdap.common.plugin.PluginKey;
import org.finos.tracdap.common.plugin.PluginServiceInfo;
import org.finos.tracdap.common.startup.StartupLog;
import org.finos.tracdap.config.PluginConfig;
import org.slf4j.event.Level;

public class PluginManager
implements IPluginManager {
    private static final List<String> CONFIG_SERVICE_TYPES = List.of("CONFIG", "SECRETS");
    private final Map<PluginKey, ITracPlugin> plugins = new HashMap<PluginKey, ITracPlugin>();

    public void initConfigPlugins() {
        StartupLog.log(this, Level.INFO, "Loading config plugins...");
        Iterator<ITracPlugin> availablePlugins = ServiceLoader.load(ITracPlugin.class).iterator();
        while (availablePlugins.hasNext()) {
            try {
                ITracPlugin plugin = availablePlugins.next();
                List<PluginServiceInfo> services = plugin.serviceInfo();
                List<PluginServiceInfo> configServices = services.stream().filter(si -> CONFIG_SERVICE_TYPES.contains(si.serviceType())).collect(Collectors.toList());
                if (configServices.isEmpty()) continue;
                StartupLog.log(this, Level.INFO, String.format("Plugin: [%s]", plugin.pluginName()));
                this.registerServices(plugin, configServices);
            }
            catch (ServiceConfigurationError e) {
                StartupLog.log(this, Level.WARN, e.getMessage());
            }
        }
    }

    public void initRegularPlugins() {
        StartupLog.log(this, Level.INFO, "Loading plugins...");
        Iterator<ITracPlugin> availablePlugins = ServiceLoader.load(ITracPlugin.class).iterator();
        while (availablePlugins.hasNext()) {
            try {
                ITracPlugin plugin = availablePlugins.next();
                List<PluginServiceInfo> services = plugin.serviceInfo();
                List<PluginServiceInfo> regularServices = services.stream().filter(si -> !CONFIG_SERVICE_TYPES.contains(si.serviceType())).collect(Collectors.toList());
                if (regularServices.isEmpty()) continue;
                StartupLog.log(this, Level.INFO, String.format("Plugin: [%s]", plugin.pluginName()));
                this.registerServices(plugin, regularServices);
            }
            catch (ServiceConfigurationError e) {
                StartupLog.log(this, Level.WARN, e.getMessage());
            }
        }
    }

    private void registerServices(ITracPlugin plugin, List<PluginServiceInfo> services) {
        for (PluginServiceInfo service : services) {
            String prettyServiceType = this.prettyTypeName(service.serviceType(), true);
            String protocols = String.join((CharSequence)", ", service.protocols());
            StartupLog.log(this, Level.INFO, String.format(" |-> %s: [%s] (protocols: %s)", prettyServiceType, service.serviceName(), protocols));
            for (String protocol : service.protocols()) {
                PluginKey pluginKey = new PluginKey(service.serviceClass(), protocol);
                this.plugins.put(pluginKey, plugin);
            }
        }
    }

    @Override
    public List<String> availableProtocols(Class<?> serviceClass) {
        HashSet<String> protocols = new HashSet<String>();
        for (PluginKey pluginKey : this.plugins.keySet()) {
            if (pluginKey.serviceClass() != serviceClass) continue;
            protocols.add(pluginKey.protocol());
        }
        return new ArrayList<String>(protocols);
    }

    @Override
    public boolean isServiceAvailable(Class<?> serviceClass, String protocol) {
        PluginKey pluginKey = new PluginKey(serviceClass, protocol);
        return this.plugins.containsKey(pluginKey);
    }

    @Override
    public <T> T createService(Class<T> serviceClass, PluginConfig pluginConfig, ConfigManager configManager) {
        ITracPlugin plugin = this.lookupPlugin(serviceClass, pluginConfig.getProtocol());
        return plugin.createService(serviceClass, pluginConfig, configManager);
    }

    @Override
    public <T> T createService(Class<T> serviceClass, String protocol, ConfigManager configManager) {
        PluginConfig pluginConfig = PluginConfig.newBuilder().setProtocol(protocol).build();
        return this.createService(serviceClass, pluginConfig, configManager);
    }

    @Override
    public <T> T createConfigService(Class<T> serviceClass, PluginConfig pluginConfig) {
        ITracPlugin plugin = this.lookupPlugin(serviceClass, pluginConfig.getProtocol());
        return plugin.createConfigService(serviceClass, pluginConfig);
    }

    @Override
    public <T> T createConfigService(Class<T> serviceClass, String protocol, Properties properties) {
        PluginConfig.Builder pluginConfig = PluginConfig.newBuilder().setProtocol(protocol);
        for (Map.Entry<Object, Object> property : properties.entrySet()) {
            String key = property.getKey().toString();
            String value = property.getValue().toString();
            pluginConfig.putProperties(key, value);
        }
        ITracPlugin plugin = this.lookupPlugin(serviceClass, protocol);
        return plugin.createConfigService(serviceClass, pluginConfig.build());
    }

    private <T> ITracPlugin lookupPlugin(Class<T> serviceClass, String protocol) {
        PluginKey pluginKey = new PluginKey(serviceClass, protocol);
        if (!PluginServiceInfo.SERVICE_TYPES.containsKey(serviceClass.getName())) {
            throw new EUnexpected();
        }
        if (protocol.isBlank()) {
            String serviceType = PluginServiceInfo.SERVICE_TYPES.get(serviceClass.getName());
            String message = String.format("Protocol not specified for [%s] plugin", serviceType);
            StartupLog.log(this, Level.ERROR, message);
            throw new EPluginNotAvailable(message);
        }
        if (!this.plugins.containsKey(pluginKey)) {
            String rawTypeName = PluginServiceInfo.SERVICE_TYPES.get(serviceClass.getName());
            String message = String.format("Plugin not available for %s protocol: [%s]", this.prettyTypeName(rawTypeName, false), protocol);
            StartupLog.log(this, Level.ERROR, message);
            throw new EPluginNotAvailable(message);
        }
        return this.plugins.get(pluginKey);
    }

    private String prettyTypeName(String rawTypeName, boolean caps) {
        String caseAndSpaces = rawTypeName.toLowerCase().replace("_", " ").replace("-", " ");
        if (caps) {
            String firstLetter = caseAndSpaces.substring(0, 1).toUpperCase();
            return firstLetter + caseAndSpaces.substring(1);
        }
        return caseAndSpaces;
    }
}

