/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.plugin;

import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.finos.tracdap.common.exception.ETracInternal;

public class PluginServiceInfo {
    public static final String CONFIG_SERVICE_TYPE = "CONFIG";
    public static final String SECRETS_SERVICE_TYPE = "SECRETS";
    public static final String AUTH_PROVIDER_SERVICE_TYPE = "AUTH_PROVIDER";
    public static final String AUTH_DATABASE_SERVICE_TYPE = "AUTH_DATABASE";
    public static final String FILE_STORAGE_SERVICE_TYPE = "FILE_STORAGE";
    public static final String DATA_STORAGE_SERVICE_TYPE = "DATA_STORAGE";
    public static final String FORMAT_SERVICE_TYPE = "FORMAT";
    public static final String EXECUTION_SERVICE_TYPE = "EXECUTION";
    public static final String JOB_CACHE_SERVICE_TYPE = "JOB_CACHE";
    public static final String METADATA_DAL_SERVICE_TYPE = "METADATA_DAL";
    static final Map<String, String> SERVICE_TYPES = Map.ofEntries(Map.entry("org.finos.tracdap.common.config.IConfigLoader", "CONFIG"), Map.entry("org.finos.tracdap.common.config.ISecretLoader", "SECRETS"), Map.entry("org.finos.tracdap.common.auth.external.IAuthProvider", "AUTH_PROVIDER"), Map.entry("org.finos.tracdap.common.auth.external.IUserDatabase", "AUTH_DATABASE"), Map.entry("org.finos.tracdap.common.codec.ICodec", "FORMAT"), Map.entry("org.finos.tracdap.common.storage.IFileStorage", "FILE_STORAGE"), Map.entry("org.finos.tracdap.common.storage.IDataStorage", "DATA_STORAGE"), Map.entry("org.finos.tracdap.common.exec.IBatchExecutor", "EXECUTION"), Map.entry("org.finos.tracdap.common.cache.IJobCacheManager", "JOB_CACHE"), Map.entry("org.finos.tracdap.svc.meta.dal.IMetadataDal", "METADATA_DAL"));
    private final Class<?> serviceClass;
    private final String serviceName;
    private final String serviceType;
    private final List<String> protocols;

    public PluginServiceInfo(@Nonnull Class<?> serviceClass, @Nonnull String serviceName, @Nonnull List<String> protocols) {
        this.serviceClass = serviceClass;
        this.serviceName = serviceName;
        this.protocols = protocols;
        this.serviceType = SERVICE_TYPES.getOrDefault(serviceClass.getName(), null);
        if (this.serviceType == null) {
            throw new ETracInternal("Service class is not a recognized pluggable service class");
        }
    }

    public Class<?> serviceClass() {
        return this.serviceClass;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public String serviceType() {
        return this.serviceType;
    }

    public List<String> protocols() {
        return this.protocols;
    }
}

