/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.finos.tracdap.common.config.ConfigManager;
import org.finos.tracdap.common.exception.EPluginNotAvailable;
import org.finos.tracdap.common.plugin.ITracPlugin;
import org.finos.tracdap.common.plugin.PluginServiceInfo;
import org.finos.tracdap.config.PluginConfig;

public abstract class TracPlugin
implements ITracPlugin {
    protected <T> T createService(String serviceName, Properties properties, ConfigManager configManager) {
        String message = String.format("Plugin [%s] does not support the service [%s]", this.pluginName(), serviceName);
        throw new EPluginNotAvailable(message);
    }

    protected <T> T createConfigService(String serviceName, Properties properties) {
        String message = String.format("Plugin [%s] does not support the service [%s]", this.pluginName(), serviceName);
        throw new EPluginNotAvailable(message);
    }

    @Override
    public final List<String> protocols(Class<?> service) {
        List<PluginServiceInfo> psi = this.serviceInfo();
        List matchingPsi = psi.stream().filter(si -> si.serviceClass() == service).collect(Collectors.toList());
        if (matchingPsi.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return matchingPsi.stream().map(PluginServiceInfo::protocols).reduce(new ArrayList(), (ps, p) -> {
            ps.addAll(p);
            return ps;
        });
    }

    @Override
    public final <T> T createService(Class<T> serviceClass, PluginConfig config, ConfigManager configManager) {
        PluginServiceInfo serviceInfo = this.lookupService(serviceClass, config.getProtocol());
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)config.getPropertiesMap());
        for (Map.Entry secret : config.getSecretsMap().entrySet()) {
            String secretKey = (String)secret.getKey();
            String secretValue = configManager.loadPassword((String)secret.getValue());
            properties.put(secretKey, secretValue);
        }
        return this.createService(serviceInfo.serviceName(), properties, configManager);
    }

    @Override
    public final <T> T createConfigService(Class<T> serviceClass, PluginConfig config) {
        PluginServiceInfo serviceInfo = this.lookupService(serviceClass, config.getProtocol());
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)config.getPropertiesMap());
        return this.createConfigService(serviceInfo.serviceName(), properties);
    }

    private <T> PluginServiceInfo lookupService(Class<T> serviceClass, String protocol) {
        List<PluginServiceInfo> psi = this.serviceInfo();
        Optional<PluginServiceInfo> matchingPsi = psi.stream().filter(psi_ -> TracPlugin.psiMatch(psi_, serviceClass, protocol)).findFirst();
        if (matchingPsi.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return matchingPsi.get();
    }

    private static boolean psiMatch(PluginServiceInfo psi, Class<?> service, String protocol) {
        if (psi.serviceClass() != service) {
            return false;
        }
        for (String psiProtocol : psi.protocols()) {
            if (!psiProtocol.equalsIgnoreCase(protocol)) continue;
            return true;
        }
        return false;
    }
}

