/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.startup;

import java.nio.file.Path;
import java.util.List;

public class StandardArgs {
    private final Path workingDir;
    private final String configFile;
    private final String secretKey;
    private final List<Task> tasks;

    public StandardArgs(Path workingDir, String configFile, String secretKey, List<Task> tasks) {
        this.workingDir = workingDir;
        this.configFile = configFile;
        this.secretKey = secretKey;
        this.tasks = tasks;
    }

    public StandardArgs(Path workingDir, String configFile, String keystoreKey) {
        this(workingDir, configFile, keystoreKey, List.of());
    }

    public Path getWorkingDir() {
        return this.workingDir;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public List<Task> getTasks() {
        return this.tasks;
    }

    public static Task task(String taskName, String taskDescription) {
        return new Task(taskName, List.of(), taskDescription);
    }

    public static Task task(String taskName, String taskArg, String taskDescription) {
        return new Task(taskName, taskArg, taskDescription);
    }

    public static Task task(String taskName, List<String> taskArgs, String taskDescription) {
        return new Task(taskName, taskArgs, taskDescription);
    }

    public static class Task {
        private final String taskName;
        private final List<String> taskArgs;
        private final String taskDescription;

        Task(String taskName, List<String> taskArgs, String taskDescription) {
            this.taskName = taskName;
            this.taskArgs = taskArgs != null ? taskArgs : List.of();
            this.taskDescription = taskDescription;
        }

        Task(String taskName, String taskArg, String taskDescription) {
            this(taskName, taskArg == null ? List.of() : List.of(taskArg), taskDescription);
        }

        Task(String taskName, String taskArg) {
            this(taskName, taskArg, null);
        }

        Task(String taskName) {
            this(taskName, null);
        }

        public String getTaskName() {
            return this.taskName;
        }

        public boolean hasArg() {
            return !this.taskArgs.isEmpty();
        }

        public int argCount() {
            return this.taskArgs.size();
        }

        public String getTaskArg() {
            return this.taskArgs.isEmpty() ? null : this.taskArgs.get(0);
        }

        public String getTaskArg(int argIndex) {
            return this.taskArgs.get(argIndex);
        }

        public List<String> getTaskArgList() {
            return this.taskArgs;
        }

        public String getTaskDescription() {
            return this.taskDescription;
        }
    }
}

