/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.startup;

import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.finos.tracdap.common.exception.EStartup;
import org.finos.tracdap.common.startup.StandardArgs;

public class StandardArgsProcessor {
    public static StandardArgs processArgs(String appName, String[] args, Map<String, String> envVariables) {
        return StandardArgsProcessor.processArgs(appName, args, null, envVariables);
    }

    public static StandardArgs processArgs(String appName, String[] args, List<StandardArgs.Task> availableTasks, Map<String, String> envVariables) {
        if (envVariables == null) {
            envVariables = Collections.emptyMap();
        }
        boolean usingTasks = availableTasks != null && !availableTasks.isEmpty();
        Options helpOptions = StandardArgsProcessor.helpOptions(usingTasks);
        Options options = StandardArgsProcessor.standardOptions(usingTasks);
        try {
            DefaultParser parser = new DefaultParser();
            CommandLine helpCommand = parser.parse(helpOptions, args, true);
            StandardArgsProcessor.handleHelpCommands(appName, helpCommand, options, availableTasks);
            CommandLine command = parser.parse(options, args, false);
            Path workingDir = Paths.get(".", new String[0]).toAbsolutePath().normalize();
            String configFile = command.getOptionValue("config");
            String secretKey = command.getOptionValue("secret-key");
            if (secretKey == null) {
                secretKey = envVariables.get("TRAC_SECRET_KEY");
            }
            List<StandardArgs.Task> tasks = usingTasks ? StandardArgsProcessor.processTasks(command, availableTasks) : null;
            return new StandardArgs(workingDir, configFile, secretKey, tasks);
        }
        catch (ParseException e) {
            String message = "Invalid command line: " + e.getMessage();
            System.err.println(message);
            HelpFormatter formatter = new HelpFormatter();
            formatter.printUsage(new PrintWriter(System.out), 80, appName, options);
            formatter.printHelp(appName, options);
            throw EStartup.quietShutdown(-1);
        }
    }

    private static void handleHelpCommands(String appName, CommandLine helpCommand, Options options, List<StandardArgs.Task> tasks) {
        if (helpCommand.hasOption("help")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(appName, options);
            throw EStartup.quietShutdown(0);
        }
        if (helpCommand.hasOption("task-list")) {
            System.out.println(appName + " - available tasks:");
            for (StandardArgs.Task task : tasks) {
                String taskInfoFormat = "%-35s %s";
                String taskUsage = task.hasArg() ? task.getTaskName() + " " + String.join((CharSequence)" ", task.getTaskArgList()) : task.getTaskName();
                System.out.printf(taskInfoFormat, taskUsage, task.getTaskDescription());
                System.out.println();
            }
            throw EStartup.quietShutdown(0);
        }
    }

    private static List<StandardArgs.Task> processTasks(CommandLine command, List<StandardArgs.Task> availableTasks) {
        Map<String, StandardArgs.Task> taskMap = availableTasks.stream().collect(Collectors.toMap(StandardArgs.Task::getTaskName, task -> task));
        String[] taskArgs = command.getOptionValues("task");
        ArrayList<StandardArgs.Task> tasks = new ArrayList<StandardArgs.Task>();
        for (int argIndex = 0; argIndex < taskArgs.length; ++argIndex) {
            String taskName = taskArgs[argIndex];
            if (!taskMap.containsKey(taskName)) {
                throw new EStartup(String.format("Unknown task: [%s]", taskName));
            }
            StandardArgs.Task taskDef = taskMap.get(taskName);
            if (taskDef.hasArg()) {
                if (taskDef.argCount() > taskArgs.length - argIndex - 1) {
                    String message = String.format("Task [%s] requires %d argument(s): %s", taskName, taskDef.argCount(), String.join((CharSequence)" ", taskDef.getTaskArgList()));
                    throw new EStartup(message);
                }
                String[] args = Arrays.copyOfRange(taskArgs, argIndex + 1, argIndex + 1 + taskDef.argCount());
                argIndex += taskDef.argCount();
                StandardArgs.Task task2 = new StandardArgs.Task(taskName, Arrays.asList(args), "");
                tasks.add(task2);
                continue;
            }
            StandardArgs.Task task3 = new StandardArgs.Task(taskName);
            tasks.add(task3);
        }
        return List.copyOf(tasks);
    }

    private static Options standardOptions(boolean usingTasks) {
        return StandardArgsProcessor.buildOOptions(usingTasks, false);
    }

    private static Options helpOptions(boolean usingTasks) {
        return StandardArgsProcessor.buildOOptions(usingTasks, true);
    }

    private static Options buildOOptions(boolean usingTasks, boolean buildingHelp) {
        Options options = new Options();
        options.addOption(Option.builder().desc("Location of the primary config file").longOpt("config").hasArg().argName("config_file").required(!buildingHelp).build());
        options.addOption(Option.builder().desc("Master key used to unlock secrets (use depends on secret.type in the primary config)").longOpt("secret-key").hasArg().argName("secret_key").build());
        options.addOption(Option.builder().desc("Display this help and then quit").longOpt("help").build());
        if (usingTasks) {
            options.addOption(Option.builder().desc("Perform a specific task").longOpt("task").hasArgs().argName("task").valueSeparator(':').required(!buildingHelp).build());
            options.addOption(Option.builder().desc("Display the list of available tasks and then quit").longOpt("task-list").build());
        }
        return options;
    }
}

