/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.startup;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class StartupLog {
    private static boolean logSystemActive = false;

    public static void setLogSystemActive() {
        logSystemActive = true;
    }

    public static void log(Object obj, Level level, String message) {
        if (logSystemActive) {
            Logger log = LoggerFactory.getLogger(obj.getClass());
            switch (level) {
                case ERROR: {
                    log.error(message);
                    break;
                }
                case WARN: {
                    log.warn(message);
                    break;
                }
                case DEBUG: {
                    log.debug(message);
                    break;
                }
                case TRACE: {
                    log.trace(message);
                    break;
                }
                default: {
                    log.info(message);
                    break;
                }
            }
        } else if (level.toInt() <= Level.INFO.toInt()) {
            System.out.println(message);
        } else {
            System.err.println(message);
        }
    }
}

