/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.startup;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.finos.tracdap.common.config.ConfigManager;
import org.finos.tracdap.common.exception.ETracInternal;
import org.finos.tracdap.common.exception.EUnexpected;
import org.finos.tracdap.common.plugin.PluginManager;
import org.finos.tracdap.common.startup.StandardArgs;
import org.finos.tracdap.common.startup.StartupLog;
import org.finos.tracdap.common.util.VersionInfo;
import org.finos.tracdap.config._ConfigFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class StartupSequence {
    private final Class<?> serviceClass;
    private final StandardArgs standardArgs;
    private final boolean doPrintBanner;
    private boolean sequenceComplete = false;
    private PluginManager plugins;
    private ConfigManager config;

    StartupSequence(Class<?> serviceClass, StandardArgs standardArgs, boolean doPrintBanner) {
        this.serviceClass = serviceClass;
        this.standardArgs = standardArgs;
        this.doPrintBanner = doPrintBanner;
    }

    public void runStartupSequence() {
        this.runStartupSequence(true);
    }

    public void runStartupSequence(boolean useSecrets) {
        if (this.doPrintBanner) {
            StartupSequence.printBanner(this.serviceClass);
        }
        this.printSubBanner();
        this.initConfigPlugins();
        this.loadConfig();
        this.initLogging();
        this.printFirstLogLine();
        this.plugins.initRegularPlugins();
        if (useSecrets) {
            this.config.prepareSecrets();
        }
        this.sequenceComplete = true;
    }

    public PluginManager getPlugins() {
        if (!this.sequenceComplete) {
            throw new ETracInternal("Startup sequence has not been run");
        }
        return this.plugins;
    }

    public ConfigManager getConfig() {
        if (!this.sequenceComplete) {
            throw new ETracInternal("Startup sequence has not been run");
        }
        return this.config;
    }

    public StandardArgs getArgs() {
        return this.standardArgs;
    }

    public static void printBanner(Class<?> serviceClass) {
        if (serviceClass != null) {
            String componentName = VersionInfo.getComponentName(serviceClass);
            String componentVersion = VersionInfo.getComponentVersion(serviceClass);
            String startupBanner = String.format(">>> %s %s", componentName, componentVersion);
            System.out.println(startupBanner);
        } else {
            System.out.println(">>> NO SERVICE REGISTERED (this should not happen in production)");
        }
    }

    private void printSubBanner() {
        System.out.println(">>> Working directory: " + String.valueOf(this.standardArgs.getWorkingDir()));
        System.out.println(">>> Config file: " + this.standardArgs.getConfigFile());
        System.out.println();
    }

    private void printFirstLogLine() {
        if (this.serviceClass != null) {
            String componentName = VersionInfo.getComponentName(this.serviceClass);
            String componentVersion = VersionInfo.getComponentVersion(this.serviceClass);
            Logger log = LoggerFactory.getLogger(this.serviceClass);
            log.info("{} {}", (Object)componentName, (Object)componentVersion);
        } else {
            Logger log = LoggerFactory.getLogger(StartupSequence.class);
            log.warn("NO SERVICE REGISTERED (this should not happen in production)");
        }
    }

    private void initConfigPlugins() {
        this.plugins = new PluginManager();
        this.plugins.initConfigPlugins();
    }

    private void loadConfig() {
        String configFile = this.standardArgs.getConfigFile();
        Path workingDir = this.standardArgs.getWorkingDir();
        String secretKey = this.standardArgs.getSecretKey();
        this.config = new ConfigManager(configFile, workingDir, this.plugins, secretKey);
    }

    private void initLogging() {
        block8: {
            _ConfigFile baseConfig = this.config.loadRootConfigObject(_ConfigFile.class, true);
            String loggingConfigUrl = baseConfig.getConfigOrDefault("logging", "");
            if (!loggingConfigUrl.isBlank()) {
                String loggingConfig = this.config.loadTextConfig(loggingConfigUrl);
                try (ByteArrayInputStream configStream = new ByteArrayInputStream(loggingConfig.getBytes());){
                    ConfigurationSource configSource = new ConfigurationSource((InputStream)configStream);
                    StartupLog.log(this, Level.INFO, "Initialize logging...");
                    Configurator.initialize((ClassLoader)this.getClass().getClassLoader(), (ConfigurationSource)configSource);
                    break block8;
                }
                catch (IOException e) {
                    throw new EUnexpected(e);
                }
            }
            StartupLog.log(this, Level.INFO, "No logging config provided, using default...");
            Configurator.reconfigure();
        }
        StartupLog.setLogSystemActive();
    }
}

