/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.util;

public class LoggingHelpers {
    public static String formatFileSize(long size) {
        if (size < 1024L) {
            if (size == 0L) {
                return "0 bytes";
            }
            if (size == 1L) {
                return "1 byte";
            }
            return String.format("%d bytes", size);
        }
        if (size < 0x100000L) {
            double kb = (double)size / 1024.0;
            return String.format("%.1f KB", kb);
        }
        if (size < 0x40000000L) {
            double mb = (double)size / 1048576.0;
            return String.format("%.1f MB", mb);
        }
        double gb = (double)size / 1.073741824E9;
        return String.format("%.1f GB", gb);
    }
}

