/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.util;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.finos.tracdap.common.exception.EResourceNotFound;

public class ResourceHelpers {
    public static ByteString loadResourceAsByteString(String resourcePath) {
        return ResourceHelpers.loadResourceAsByteString(resourcePath, ResourceHelpers.class);
    }

    public static ByteString loadResourceAsByteString(String resourcePath, Class<?> clazz) {
        byte[] bytes = ResourceHelpers.loadResourceAsBytes(resourcePath, clazz);
        return ByteString.copyFrom((byte[])bytes);
    }

    public static String loadResourceAsString(String resourcePath, Class<?> clazz) {
        byte[] bytes = ResourceHelpers.loadResourceAsBytes(resourcePath, clazz);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static byte[] loadResourceAsBytes(String resourcePath) {
        return ResourceHelpers.loadResourceAsBytes(resourcePath, ResourceHelpers.class);
    }

    public static byte[] loadResourceAsBytes(String resourcePath, Class<?> clazz) {
        byte[] byArray;
        block9: {
            InputStream stream = clazz.getResourceAsStream(resourcePath);
            try {
                if (stream == null) {
                    throw new IOException("Failed to load resource: [" + resourcePath + "]");
                }
                byArray = stream.readAllBytes();
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new EResourceNotFound(e.getMessage(), e);
                }
            }
            stream.close();
        }
        return byArray;
    }
}

