/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.util;

import java.util.Map;
import org.finos.tracdap.common.exception.EConfig;
import org.finos.tracdap.common.exception.EUnexpected;
import org.finos.tracdap.config.PlatformConfig;
import org.finos.tracdap.config.RoutingTarget;
import org.finos.tracdap.config.ServiceConfig;

public class RoutingUtils {
    private static final Map<String, String> STANDARD_ALIASES = Map.ofEntries(Map.entry("metadata", "tracdap-svc-meta"), Map.entry("data", "tracdap-svc-data"), Map.entry("orchestrator", "tracdap-svc-orch"), Map.entry("webServer", "tracdap-webserver"), Map.entry("gateway", "tracdap-gateway"));

    public static RoutingTarget serviceTarget(PlatformConfig platformConfig, String serviceKey) {
        if (!platformConfig.containsServices(serviceKey)) {
            throw new EConfig(String.format("Missing or invalid config: services.%s", serviceKey));
        }
        ServiceConfig serviceConfig = platformConfig.getServicesOrThrow(serviceKey);
        switch (platformConfig.getDeployment().getLayout()) {
            case LAYOUT_NOT_SET: {
                throw new EConfig("Missing or invalid config: [deployment.layout]");
            }
            case SANDBOX: {
                return RoutingTarget.newBuilder().setHost("localhost").setPort(serviceConfig.getPort()).build();
            }
            case HOSTED: {
                String hostedAlias = serviceConfig.getAlias();
                String serviceAlias = hostedAlias.isEmpty() ? STANDARD_ALIASES.get(serviceKey) : hostedAlias;
                return RoutingTarget.newBuilder().setHost(serviceAlias).setPort(serviceConfig.getPort()).build();
            }
            case CUSTOM: {
                String customAlias = serviceConfig.getAlias();
                if (customAlias.isEmpty()) {
                    throw new EConfig(String.format("Missing or invalid config: services.%s.alias", serviceKey));
                }
                return RoutingTarget.newBuilder().setHost(customAlias).setPort(serviceConfig.getPort()).build();
            }
        }
        throw new EUnexpected();
    }
}

