/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.db;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.finos.tracdap.common.db.JdbcDialect;
import org.finos.tracdap.common.exception.EStartup;
import org.finos.tracdap.common.exception.ETracInternal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcSetup {
    private static final String DIALECT_PROPERTY = "dialect";
    private static final String JDBC_URL_PROPERTY = "jdbcUrl";

    public static JdbcDialect getSqlDialect(Properties props, String configBase) {
        String dialectPropKey = configBase + DIALECT_PROPERTY;
        String dialect = props.getProperty(dialectPropKey, null);
        if (dialect == null || dialect.isBlank()) {
            throw new EStartup("Missing required config property: " + dialectPropKey);
        }
        try {
            return Enum.valueOf(JdbcDialect.class, dialect);
        }
        catch (IllegalArgumentException e) {
            throw new EStartup(String.format("Unsupported SQL dialect: [%s]", dialect));
        }
    }

    public static DataSource createDatasource(Properties props, String configBase) {
        try {
            Properties hikariProps = JdbcSetup.createHikariProperties(props, configBase);
            HikariConfig config = new HikariConfig(hikariProps);
            HikariDataSource source = new HikariDataSource(config);
            Logger log = LoggerFactory.getLogger(JdbcSetup.class);
            log.info("Database connection pool has " + source.getMaximumPoolSize() + " connections");
            return source;
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof SQLException && !e.getMessage().contains(e.getCause().getMessage())) {
                String messageTemplate = "Could not connect to database: %s (%s)";
                String message = String.format(messageTemplate, e.getMessage(), e.getCause().getMessage());
                throw new EStartup(message, (Throwable)e);
            }
            String messageTemplate = "Could not connect to database: %s";
            String message = String.format(messageTemplate, e.getMessage());
            throw new EStartup(message, (Throwable)e);
        }
    }

    public static void destroyDatasource(DataSource source) {
        if (!(source instanceof HikariDataSource)) {
            throw new ETracInternal("Datasource being destroyed was not created by JdbcSetup");
        }
        HikariDataSource hikariSource = (HikariDataSource)source;
        hikariSource.close();
    }

    private static Properties createHikariProperties(Properties props, String configBase) {
        if (!((String)configBase).isEmpty() && !((String)configBase).endsWith(".")) {
            configBase = (String)configBase + ".";
        }
        JdbcDialect dialect = JdbcSetup.getSqlDialect(props, (String)configBase);
        String jdbcUrl = JdbcSetup.buildJdbcUrl(props, (String)configBase, dialect);
        Properties hikariProps = new Properties();
        hikariProps.setProperty(JDBC_URL_PROPERTY, jdbcUrl);
        JdbcSetup.copyDialectProperties(props, hikariProps, (String)configBase, dialect);
        hikariProps.setProperty("poolName", "dal_worker_pool");
        String poolSize = props.getProperty((String)configBase + "pool.size");
        if (poolSize != null && !poolSize.isBlank()) {
            hikariProps.setProperty("maximumPoolSize", poolSize);
        }
        return hikariProps;
    }

    private static String buildJdbcUrl(Properties rootProps, String configBase, JdbcDialect dialect) {
        String jdbcUrlProperty = configBase + JDBC_URL_PROPERTY;
        String jdbcUrlFromConfig = rootProps.getProperty(jdbcUrlProperty);
        return String.format("jdbc:%s:%s", dialect.name().toLowerCase(), jdbcUrlFromConfig);
    }

    private static void copyDialectProperties(Properties rootProps, Properties hikariProps, String configBase, JdbcDialect dialect) {
        String dialectPrefixFormat = "%s%s.";
        String dialectPrefix = String.format(dialectPrefixFormat, configBase, dialect.name().toLowerCase());
        for (String propKey : rootProps.stringPropertyNames()) {
            if (!propKey.startsWith(dialectPrefix)) continue;
            String dialectProperty = propKey.substring(dialectPrefix.length());
            String hikariPropKey = "dataSource." + dialectProperty;
            String propValue = rootProps.getProperty(propKey);
            hikariProps.setProperty(hikariPropKey, propValue);
        }
    }
}

