/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.test.concurrent;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ConcurrentTestHelpers {
    public static void waitFor(Duration timeout, CompletionStage<?> ... tasks) {
        ConcurrentTestHelpers.waitFor(timeout, Arrays.asList(tasks));
    }

    public static void waitFor(Duration timeout, List<CompletionStage<?>> tasks) {
        CountDownLatch latch = new CountDownLatch(tasks.size());
        for (CompletionStage<?> task : tasks) {
            task.whenComplete((result, error) -> latch.countDown());
        }
        try {
            boolean complete = latch.await(timeout.getSeconds(), TimeUnit.SECONDS);
            if (!complete) {
                throw new RuntimeException("Test timed out");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Test interrupted", e);
        }
    }

    public static <T> T resultOf(CompletionStage<T> task, boolean unwrap) throws Exception {
        CompletableFuture<T> taskFuture = task.toCompletableFuture();
        if (!taskFuture.isDone()) {
            throw new RuntimeException("Result of task is not ready");
        }
        try {
            return task.toCompletableFuture().join();
        }
        catch (CompletionException e) {
            if (!unwrap) {
                throw e;
            }
            Throwable cause = e.getCause();
            throw cause instanceof Exception ? (Exception)cause : e;
        }
    }

    public static <T> T resultOf(CompletionStage<T> task) throws Exception {
        return ConcurrentTestHelpers.resultOf(task, true);
    }
}

