/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.test.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import org.finos.tracdap.common.exception.EUnexpected;

public class ConfigHelpers {
    private static final String BACKSLASH = "/";

    public static URL prepareConfig(String rootConfigFile, Path targetDir, Map<String, String> substitutions) throws Exception {
        URL rootConfigUrl;
        URL uRL = rootConfigUrl = Files.exists(Paths.get(rootConfigFile, new String[0]), new LinkOption[0]) ? Paths.get(rootConfigFile, new String[0]).toAbsolutePath().normalize().toUri().toURL() : ConfigHelpers.class.getClassLoader().getResource(rootConfigFile);
        if (rootConfigUrl == null) {
            String err = String.format("Config resource not found: [%s]", rootConfigFile);
            throw new RuntimeException(err);
        }
        String rootConfigDir = rootConfigFile.contains(BACKSLASH) ? rootConfigFile.substring(0, rootConfigFile.lastIndexOf(BACKSLASH) + 1) : rootConfigFile;
        String pathSeparator = FileSystems.getDefault().getSeparator();
        if (rootConfigUrl.getProtocol().equals("jar")) {
            String resourcePath = ConfigHelpers.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            if (resourcePath.startsWith(BACKSLASH) && !BACKSLASH.equals(pathSeparator)) {
                resourcePath = resourcePath.substring(1);
            }
            ConfigHelpers.copyConfigFromJar(resourcePath, rootConfigDir, targetDir);
        } else {
            String rootConfigPath = rootConfigUrl.getPath();
            if (rootConfigPath.startsWith(BACKSLASH) && !BACKSLASH.equals(pathSeparator)) {
                rootConfigPath = rootConfigPath.substring(1);
            }
            Path sourceDir = Paths.get(rootConfigPath, new String[0]).getParent();
            Path targetConfigDir = targetDir.resolve(rootConfigDir);
            Files.createDirectories(targetConfigDir, new FileAttribute[0]);
            ConfigHelpers.copyConfigDir(sourceDir, targetConfigDir);
        }
        Path targetRootFile = targetDir.resolve(rootConfigFile);
        ConfigHelpers.setConfigVars(targetRootFile, substitutions);
        return targetRootFile.toUri().toURL();
    }

    public static void copyConfigFromJar(String jarPath, String rootConfigPath, Path targetDir) throws IOException {
        try (JarFile jar = new JarFile(jarPath);){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith(rootConfigPath)) continue;
                if (entry.isDirectory()) {
                    Files.createDirectory(targetDir.resolve(name), new FileAttribute[0]);
                    continue;
                }
                InputStream stream = jar.getInputStream(entry);
                try {
                    long size = entry.getSize();
                    byte[] bytes = new byte[(int)size];
                    int sizeRead = stream.read(bytes);
                    if ((long)sizeRead != size) {
                        throw new EUnexpected();
                    }
                    Files.write(targetDir.resolve(name), bytes, new OpenOption[0]);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
        }
    }

    public static void copyConfigDir(Path sourceDir, Path targetDir) throws IOException {
        try (Stream<Path> sourceFiles = Files.walk(sourceDir, new FileVisitOption[0]);){
            sourceFiles.filter(sourceFile -> !sourceFile.equals(sourceDir)).forEach(sourceFile -> {
                try {
                    Path targetFile = targetDir.resolve(sourceFile.getFileName());
                    if (Files.isDirectory(sourceFile, new LinkOption[0])) {
                        Files.createDirectory(targetFile, new FileAttribute[0]);
                        ConfigHelpers.copyConfigDir(sourceFile, targetFile);
                    } else {
                        Files.copy(sourceFile, targetFile, new CopyOption[0]);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            });
        }
    }

    public static void setConfigVars(Path configFile, Map<String, String> substitutions) throws IOException {
        String configText = Files.readString(configFile);
        for (Map.Entry<String, String> sub : substitutions.entrySet()) {
            configText = configText.replace(sub.getKey(), sub.getValue());
        }
        Files.writeString(configFile, (CharSequence)configText, new OpenOption[0]);
    }
}

