/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.test.data;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.TimeStampMilliVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.finos.tracdap.common.data.ArrowSchema;
import org.finos.tracdap.common.exception.ETracInternal;
import org.finos.tracdap.common.exception.EUnexpected;
import org.finos.tracdap.metadata.BasicType;
import org.finos.tracdap.metadata.FieldSchema;
import org.finos.tracdap.metadata.SchemaDefinition;
import org.finos.tracdap.metadata.SchemaType;
import org.finos.tracdap.metadata.TableSchema;

public class SampleData {
    public static final String BASIC_CSV_DATA_RESOURCE = "/sample_data/csv_basic.csv";
    public static final String BASIC_CSV_DATA_RESOURCE_V2 = "/sample_data/csv_basic_v2.csv";
    public static final String BASIC_JSON_DATA_RESOURCE = "/sample_data/json_basic.json";
    public static final SchemaDefinition BASIC_TABLE_SCHEMA = SchemaDefinition.newBuilder().setSchemaType(SchemaType.TABLE).setTable(TableSchema.newBuilder().addFields(FieldSchema.newBuilder().setFieldName("boolean_field").setFieldOrder(0).setFieldType(BasicType.BOOLEAN)).addFields(FieldSchema.newBuilder().setFieldName("integer_field").setFieldOrder(1).setFieldType(BasicType.INTEGER)).addFields(FieldSchema.newBuilder().setFieldName("float_field").setFieldOrder(2).setFieldType(BasicType.FLOAT)).addFields(FieldSchema.newBuilder().setFieldName("decimal_field").setFieldOrder(3).setFieldType(BasicType.DECIMAL)).addFields(FieldSchema.newBuilder().setFieldName("string_field").setFieldOrder(4).setFieldType(BasicType.STRING)).addFields(FieldSchema.newBuilder().setFieldName("date_field").setFieldOrder(5).setFieldType(BasicType.DATE)).addFields(FieldSchema.newBuilder().setFieldName("datetime_field").setFieldOrder(6).setFieldType(BasicType.DATETIME))).build();
    public static final SchemaDefinition BASIC_TABLE_SCHEMA_V2 = BASIC_TABLE_SCHEMA.toBuilder().setTable(BASIC_TABLE_SCHEMA.getTable().toBuilder().addFields(FieldSchema.newBuilder().setFieldName("extra_string_field").setFieldOrder(7).setFieldType(BasicType.STRING))).build();

    public static VectorSchemaRoot generateBasicData(BufferAllocator arrowAllocator) {
        HashMap<String, List<Object>> javaData = new HashMap<String, List<Object>>();
        for (FieldSchema field : BASIC_TABLE_SCHEMA.getTable().getFieldsList()) {
            List<Object> javaValues = SampleData.generateJavaValues(field.getFieldType(), 10);
            javaData.put(field.getFieldName(), javaValues);
        }
        return SampleData.convertData(BASIC_TABLE_SCHEMA, javaData, 10, arrowAllocator);
    }

    public static List<Object> generateJavaValues(BasicType basicType, int n) {
        switch (basicType) {
            case BOOLEAN: {
                return IntStream.range(0, n).mapToObj(i -> i % 2 == 0).collect(Collectors.toList());
            }
            case INTEGER: {
                return IntStream.range(0, n).mapToObj(i -> i).collect(Collectors.toList());
            }
            case FLOAT: {
                return IntStream.range(0, n).mapToObj(i -> i).collect(Collectors.toList());
            }
            case DECIMAL: {
                return IntStream.range(0, n).mapToObj(BigDecimal::valueOf).map(d -> d.setScale(12, RoundingMode.UNNECESSARY)).collect(Collectors.toList());
            }
            case STRING: {
                return IntStream.range(0, n).mapToObj(i -> "Hello world " + i).collect(Collectors.toList());
            }
            case DATE: {
                return IntStream.range(0, n).mapToObj(i -> LocalDate.ofEpochDay(0L).plusDays(i)).collect(Collectors.toList());
            }
            case DATETIME: {
                return IntStream.range(0, n).mapToObj(i -> LocalDateTime.ofEpochSecond(0L, 0, ZoneOffset.UTC).plusSeconds(i)).collect(Collectors.toList());
            }
        }
        throw new EUnexpected();
    }

    public static VectorSchemaRoot convertData(SchemaDefinition schema, Map<String, List<Object>> data, int size, BufferAllocator arrowAllocator) {
        return SampleData.convertData(ArrowSchema.tracToArrow((SchemaDefinition)schema), data, size, arrowAllocator);
    }

    public static VectorSchemaRoot convertData(Schema schema, Map<String, List<Object>> data, int size, BufferAllocator arrowAllocator) {
        for (String fieldName : data.keySet()) {
            if (schema.findField(fieldName) != null) continue;
            throw new ETracInternal("Sample data field " + fieldName + " is not present in the schema");
        }
        ArrayList<BitVector> vectors = new ArrayList<BitVector>(schema.getFields().size());
        for (Field field : schema.getFields()) {
            BiConsumer<Integer, Object> setFunc;
            BitVector vector;
            switch (field.getType().getTypeID()) {
                case Bool: {
                    BitVector booleanVec;
                    vector = booleanVec = new BitVector(field, arrowAllocator);
                    setFunc = (i, o) -> {
                        if (o == null) {
                            booleanVec.setNull(i.intValue());
                        } else if (o instanceof Boolean) {
                            booleanVec.set(i.intValue(), (Boolean)o != false ? 1 : 0);
                        } else {
                            throw new EUnexpected();
                        }
                    };
                    break;
                }
                case Int: {
                    BigIntVector intVec = new BigIntVector(field, arrowAllocator);
                    vector = intVec;
                    setFunc = (i, o) -> {
                        if (o == null) {
                            intVec.setNull(i.intValue());
                        } else if (o instanceof Integer) {
                            intVec.set(i.intValue(), (long)((Integer)o).intValue());
                        } else if (o instanceof Long) {
                            intVec.set(i.intValue(), ((Long)o).longValue());
                        } else {
                            throw new EUnexpected();
                        }
                    };
                    break;
                }
                case FloatingPoint: {
                    Float8Vector floatVec = new Float8Vector(field, arrowAllocator);
                    vector = floatVec;
                    setFunc = (i, o) -> {
                        if (o == null) {
                            floatVec.setNull(i.intValue());
                        } else if (o instanceof Float) {
                            floatVec.set(i.intValue(), (double)((Float)o).floatValue());
                        } else if (o instanceof Double) {
                            floatVec.set(i.intValue(), ((Double)o).doubleValue());
                        } else {
                            throw new EUnexpected();
                        }
                    };
                    break;
                }
                case Decimal: {
                    DecimalVector decimalVec = new DecimalVector(field, arrowAllocator);
                    vector = decimalVec;
                    setFunc = (i, o) -> {
                        if (o == null) {
                            decimalVec.setNull(i.intValue());
                        } else if (o instanceof BigDecimal) {
                            decimalVec.set(i.intValue(), (BigDecimal)o);
                        } else {
                            throw new EUnexpected();
                        }
                    };
                    break;
                }
                case Utf8: {
                    VarCharVector stringVec = new VarCharVector(field, arrowAllocator);
                    vector = stringVec;
                    setFunc = (i, o) -> {
                        if (o == null) {
                            stringVec.setNull(i.intValue());
                        } else if (o instanceof String) {
                            stringVec.set(i.intValue(), ((String)o).getBytes(StandardCharsets.UTF_8));
                        } else {
                            throw new EUnexpected();
                        }
                    };
                    break;
                }
                case Date: {
                    DateDayVector dateVec = new DateDayVector(field, arrowAllocator);
                    vector = dateVec;
                    setFunc = (i, o) -> {
                        if (o == null) {
                            dateVec.setNull(i.intValue());
                        } else if (o instanceof LocalDate) {
                            dateVec.set(i.intValue(), (int)((LocalDate)o).toEpochDay());
                        } else {
                            throw new EUnexpected();
                        }
                    };
                    break;
                }
                case Timestamp: {
                    TimeStampMilliVector timestampVec = new TimeStampMilliVector(field, arrowAllocator);
                    vector = timestampVec;
                    setFunc = (i, o) -> {
                        if (o == null) {
                            timestampVec.setNull(i.intValue());
                        } else if (o instanceof LocalDateTime) {
                            LocalDateTime datetimeNoZone = (LocalDateTime)o;
                            long unixEpochMillis = datetimeNoZone.toEpochSecond(ZoneOffset.UTC) * 1000L + (long)(datetimeNoZone.getNano() / 1000000);
                            timestampVec.set(i.intValue(), unixEpochMillis);
                        } else {
                            throw new EUnexpected();
                        }
                    };
                    break;
                }
                default: {
                    throw new EUnexpected();
                }
            }
            vector.allocateNew();
            vector.setInitialCapacity(size);
            List<Object> values = data.get(field.getName());
            if (values == null) {
                values = Collections.nCopies(size, null);
            }
            for (int i2 = 0; i2 < size; ++i2) {
                setFunc.accept(i2, values.get(i2));
            }
            vectors.add(vector);
        }
        VectorSchemaRoot root = new VectorSchemaRoot(schema.getFields(), vectors);
        root.setRowCount(size);
        return root;
    }
}

