/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.test.helpers;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.netty.NettyChannelBuilder;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.finos.tracdap.api.TracDataApiGrpc;
import org.finos.tracdap.api.TracMetadataApiGrpc;
import org.finos.tracdap.api.TracOrchestratorApiGrpc;
import org.finos.tracdap.api.TrustedMetadataApiGrpc;
import org.finos.tracdap.common.config.ConfigManager;
import org.finos.tracdap.common.plugin.IPluginManager;
import org.finos.tracdap.common.plugin.PluginManager;
import org.finos.tracdap.common.startup.StandardArgs;
import org.finos.tracdap.config.InstanceConfig;
import org.finos.tracdap.config.PlatformConfig;
import org.finos.tracdap.svc.data.TracDataService;
import org.finos.tracdap.svc.meta.TracMetadataService;
import org.finos.tracdap.svc.orch.TracOrchestratorService;
import org.finos.tracdap.test.config.ConfigHelpers;
import org.finos.tracdap.test.helpers.ServiceHelpers;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformTest
implements BeforeAllCallback,
AfterAllCallback {
    public static final String TRAC_EXEC_DIR = "TRAC_EXEC_DIR";
    public static final String STORAGE_ROOT_DIR = "storage_root";
    public static final String DEFAULT_STORAGE_FORMAT = "ARROW_FILE";
    private static final boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase().contains("windows");
    private static final String PYTHON_EXE = IS_WINDOWS ? "python.exe" : "python";
    private static final String VENV_BIN_SUBDIR = IS_WINDOWS ? "Scripts" : "bin";
    private static final String VENV_ENV_VAR = "VIRTUAL_ENV";
    private static final String TRAC_RUNTIME_DIST_DIR = "tracdap-runtime/python/build/dist";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String testConfig;
    private final List<String> tenants;
    private final String storageFormat;
    private final boolean runDbDeploy;
    private final boolean startMeta;
    private final boolean startData;
    private final boolean startOrch;
    private Path tracDir;
    private Path tracStorageDir;
    private Path tracExecDir;
    private Path tracRepoDir;
    private URL platformConfigUrl;
    private String keystoreKey;
    private PlatformConfig platformConfig;
    private TracMetadataService metaSvc;
    private TracDataService dataSvc;
    private TracOrchestratorService orchSvc;
    private ManagedChannel metaChannel;
    private ManagedChannel dataChannel;
    private ManagedChannel orchChannel;

    private PlatformTest(String testConfig, List<String> tenants, String storageFormat, boolean runDbDeploy, boolean startMeta, boolean startData, boolean startOrch) {
        this.testConfig = testConfig;
        this.tenants = tenants;
        this.storageFormat = storageFormat;
        this.runDbDeploy = runDbDeploy;
        this.startMeta = startMeta;
        this.startData = startData;
        this.startOrch = startOrch;
    }

    public static Builder forConfig(String testConfig) {
        Builder builder = new Builder();
        builder.testConfig = testConfig;
        return builder;
    }

    public TracMetadataApiGrpc.TracMetadataApiFutureStub metaClientFuture() {
        return TracMetadataApiGrpc.newFutureStub((Channel)this.metaChannel);
    }

    public TracMetadataApiGrpc.TracMetadataApiBlockingStub metaClientBlocking() {
        return TracMetadataApiGrpc.newBlockingStub((Channel)this.metaChannel);
    }

    public TrustedMetadataApiGrpc.TrustedMetadataApiBlockingStub metaClientTrustedBlocking() {
        return TrustedMetadataApiGrpc.newBlockingStub((Channel)this.metaChannel);
    }

    public TracDataApiGrpc.TracDataApiStub dataClient() {
        return TracDataApiGrpc.newStub((Channel)this.dataChannel);
    }

    public TracDataApiGrpc.TracDataApiBlockingStub dataClientBlocking() {
        return TracDataApiGrpc.newBlockingStub((Channel)this.dataChannel);
    }

    public TracOrchestratorApiGrpc.TracOrchestratorApiBlockingStub orchClientBlocking() {
        return TracOrchestratorApiGrpc.newBlockingStub((Channel)this.orchChannel);
    }

    public Path storageRootDir() {
        return this.tracStorageDir;
    }

    public Path tracRepoDir() {
        return this.tracRepoDir;
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        this.findDirectories();
        this.prepareConfig();
        this.preparePlugins();
        if (this.runDbDeploy) {
            this.prepareDatabase();
        }
        this.startServices();
        this.startClients();
    }

    public void afterAll(ExtensionContext context) throws Exception {
        this.stopClients();
        this.stopServices();
        this.cleanupDirectories();
    }

    void findDirectories() throws Exception {
        this.tracDir = Files.createTempDirectory("trac_platform_test_", new FileAttribute[0]);
        this.tracStorageDir = this.tracDir.resolve(STORAGE_ROOT_DIR);
        Files.createDirectory(this.tracStorageDir, new FileAttribute[0]);
        this.tracExecDir = System.getenv().containsKey(TRAC_EXEC_DIR) ? Paths.get(System.getenv(TRAC_EXEC_DIR), new String[0]) : this.tracDir;
        this.tracRepoDir = Paths.get(".", new String[0]).toAbsolutePath();
        while (!Files.exists(this.tracRepoDir.resolve("tracdap-api"), new LinkOption[0])) {
            this.tracRepoDir = this.tracRepoDir.getParent();
        }
    }

    void cleanupDirectories() {
        try (Stream<Path> walk = Files.walk(this.tracDir, new FileVisitOption[0]);){
            walk.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
        catch (IOException e) {
            this.log.warn("Failed to clean up test files: " + e.getMessage(), (Throwable)e);
        }
    }

    void prepareConfig() throws Exception {
        this.log.info("Prepare config for platform testing...");
        String currentGitOrigin = this.startOrch ? this.getCurrentGitOrigin() : "git_repo_not_configured";
        Map<String, String> substitutions = Map.of("${TRAC_DIR}", this.tracDir.toString().replace("\\", "\\\\"), "${TRAC_STORAGE_DIR}", this.tracStorageDir.toString().replace("\\", "\\\\"), "${STORAGE_FORMAT}", this.storageFormat, "${TRAC_EXEC_DIR}", this.tracExecDir.toString().replace("\\", "\\\\"), "${TRAC_LOCAL_REPO}", this.tracRepoDir.toString(), "${TRAC_GIT_REPO}", currentGitOrigin);
        this.platformConfigUrl = ConfigHelpers.prepareConfig(this.testConfig, this.tracDir, substitutions);
        this.keystoreKey = "";
        PluginManager plugins = new PluginManager();
        plugins.initConfigPlugins();
        ConfigManager config = new ConfigManager(this.platformConfigUrl.toString(), this.tracDir, (IPluginManager)plugins);
        this.platformConfig = (PlatformConfig)config.loadRootConfigObject(PlatformConfig.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCurrentGitOrigin() throws Exception {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command("git", "config", "--get", "remote.origin.url");
        Process proc = pb.start();
        try {
            proc.waitFor(10L, TimeUnit.SECONDS);
            byte[] procResult = proc.getInputStream().readAllBytes();
            String origin = new String(procResult, StandardCharsets.UTF_8).strip();
            this.log.info("Using Git origin: {}", (Object)origin);
            String string = origin;
            return string;
        }
        finally {
            proc.destroy();
        }
    }

    void prepareDatabase() {
        this.log.info("Deploy database schema...");
        ArrayList<StandardArgs.Task> databaseTasks = new ArrayList<StandardArgs.Task>();
        databaseTasks.add(StandardArgs.task((String)"deploy_schema", (String)"", (String)""));
        for (String tenant : this.tenants) {
            databaseTasks.add(StandardArgs.task((String)"add_tenant", (String)tenant, (String)""));
        }
        ServiceHelpers.runDbDeploy(this.tracDir, this.platformConfigUrl, this.keystoreKey, databaseTasks);
    }

    void preparePlugins() throws Exception {
        if (this.startData) {
            Files.createDirectory(this.tracDir.resolve("unit_test_storage"), new FileAttribute[0]);
        }
        if (this.startOrch) {
            Path venvDir = this.tracExecDir.resolve("venv").normalize();
            if (Files.exists(venvDir, new LinkOption[0])) {
                this.log.info("Using existing venv: [{}]", (Object)venvDir);
            } else {
                this.log.info("Creating a new venv: [{}]", (Object)venvDir);
                Path venvPath = this.tracDir.resolve("venv");
                ProcessBuilder venvPb = new ProcessBuilder(new String[0]);
                venvPb.command("python", "-m", "venv", venvPath.toString());
                Process venvP = venvPb.start();
                venvP.waitFor(60L, TimeUnit.SECONDS);
                this.log.info("Installing TRAC runtime for Python...");
                String pythonExe = venvPath.resolve(VENV_BIN_SUBDIR).resolve(PYTHON_EXE).toString();
                Path tracRtDistDir = this.tracRepoDir.resolve(TRAC_RUNTIME_DIST_DIR);
                Optional<Path> tracRtWhl = Files.find(tracRtDistDir, 1, (file, attrs) -> file.toString().endsWith(".whl"), new FileVisitOption[0]).findFirst();
                if (tracRtWhl.isEmpty()) {
                    throw new RuntimeException("Could not find TRAC runtime wheel");
                }
                ProcessBuilder pipPB = new ProcessBuilder(new String[0]);
                pipPB.command(pythonExe, "-m", "pip", "install", tracRtWhl.get().toString());
                pipPB.environment().put(VENV_ENV_VAR, venvPath.toString());
                Process pipP = pipPB.start();
                pipP.waitFor(2L, TimeUnit.MINUTES);
            }
        }
    }

    void startServices() {
        if (this.startMeta) {
            this.metaSvc = ServiceHelpers.startService(TracMetadataService.class, this.tracDir, this.platformConfigUrl, this.keystoreKey);
        }
        if (this.startData) {
            this.dataSvc = ServiceHelpers.startService(TracDataService.class, this.tracDir, this.platformConfigUrl, this.keystoreKey);
        }
        if (this.startOrch) {
            this.orchSvc = ServiceHelpers.startService(TracOrchestratorService.class, this.tracDir, this.platformConfigUrl, this.keystoreKey);
        }
    }

    void stopServices() {
        if (this.orchSvc != null) {
            this.orchSvc.stop();
        }
        if (this.dataSvc != null) {
            this.dataSvc.stop();
        }
        if (this.metaSvc != null) {
            this.metaSvc.stop();
        }
    }

    void startClients() {
        if (this.startMeta) {
            this.metaChannel = this.channelForInstance(this.platformConfig.getInstances().getMeta(0));
        }
        if (this.startData) {
            this.dataChannel = this.channelForInstance(this.platformConfig.getInstances().getData(0));
        }
        if (this.startOrch) {
            this.orchChannel = this.channelForInstance(this.platformConfig.getInstances().getOrch(0));
        }
    }

    void stopClients() throws Exception {
        if (this.orchChannel != null) {
            this.orchChannel.shutdown().awaitTermination(10L, TimeUnit.SECONDS);
        }
        if (this.dataChannel != null) {
            this.dataChannel.shutdown().awaitTermination(10L, TimeUnit.SECONDS);
        }
        if (this.metaChannel != null) {
            this.metaChannel.shutdown().awaitTermination(10L, TimeUnit.SECONDS);
        }
    }

    ManagedChannel channelForInstance(InstanceConfig instance) {
        NettyChannelBuilder builder = NettyChannelBuilder.forAddress((String)instance.getHost(), (int)instance.getPort());
        if (instance.getScheme().equalsIgnoreCase("HTTP")) {
            builder.usePlaintext();
        }
        builder.directExecutor();
        return builder.build();
    }

    public static class Builder {
        private String testConfig;
        private final List<String> tenants = new ArrayList<String>();
        private String storageFormat = "ARROW_FILE";
        private boolean runDbDeploy = true;
        private boolean startMeta;
        private boolean startData;
        private boolean startOrch;

        public Builder addTenant(String testTenant) {
            this.tenants.add(testTenant);
            return this;
        }

        public Builder storageFormat(String storageFormat) {
            this.storageFormat = storageFormat;
            return this;
        }

        public Builder runDbDeploy(boolean runDbDeploy) {
            this.runDbDeploy = runDbDeploy;
            return this;
        }

        public Builder startMeta() {
            this.startMeta = true;
            return this;
        }

        public Builder startData() {
            this.startData = true;
            return this;
        }

        public Builder startOrch() {
            this.startOrch = true;
            return this;
        }

        public Builder startAll() {
            return this.startMeta().startData().startOrch();
        }

        public PlatformTest build() {
            return new PlatformTest(this.testConfig, this.tenants, this.storageFormat, this.runDbDeploy, this.startMeta, this.startData, this.startOrch);
        }
    }
}

