/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.test.helpers;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import org.finos.tracdap.common.config.ConfigManager;
import org.finos.tracdap.common.exception.ETracInternal;
import org.finos.tracdap.common.plugin.PluginManager;
import org.finos.tracdap.common.service.CommonServiceBase;
import org.finos.tracdap.common.startup.StandardArgs;
import org.finos.tracdap.common.startup.Startup;
import org.finos.tracdap.common.startup.StartupSequence;
import org.finos.tracdap.svc.meta.TracMetadataService;
import org.finos.tracdap.tools.deploy.metadb.DeployMetaDB;

public class ServiceHelpers {
    public static void runDbDeploy(Path workingDir, URL configPath, String keystoreKey, List<StandardArgs.Task> tasks) {
        StartupSequence startup = Startup.useConfigFile(DeployMetaDB.class, (Path)workingDir, (String)configPath.toString(), (String)keystoreKey);
        startup.runStartupSequence();
        ConfigManager config = startup.getConfig();
        DeployMetaDB deployDb = new DeployMetaDB(config);
        deployDb.runDeployment(tasks);
    }

    public static <TSvc extends CommonServiceBase> TSvc startService(Class<TSvc> serviceClass, Path workingDir, URL configPath, String keystoreKey) {
        try {
            StartupSequence startup = Startup.useConfigFile(TracMetadataService.class, (Path)workingDir, (String)configPath.toString(), (String)keystoreKey);
            startup.runStartupSequence();
            PluginManager plugins = startup.getPlugins();
            ConfigManager config = startup.getConfig();
            Constructor<TSvc> constructor = serviceClass.getConstructor(PluginManager.class, ConfigManager.class);
            CommonServiceBase service = (CommonServiceBase)constructor.newInstance(plugins, config);
            service.start();
            return (TSvc)service;
        }
        catch (NoSuchMethodException e) {
            String err = String.format("Service class [%s] does not provide the standard service constructor", serviceClass.getSimpleName());
            throw new ETracInternal(err);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            String err = String.format("Service class [%s] cannot be constructed: %s", serviceClass.getSimpleName(), e.getMessage());
            throw new ETracInternal(err, (Throwable)e);
        }
    }
}

