/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.test.helpers;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public class TestResourceHelpers {
    public static ByteString loadResourceAsByteString(String resourcePath) {
        return TestResourceHelpers.loadResourceAsByteString(resourcePath, TestResourceHelpers.class);
    }

    public static ByteString loadResourceAsByteString(String resourcePath, Class<?> clazz) {
        byte[] bytes = TestResourceHelpers.loadResourceAsBytes(resourcePath, clazz);
        return ByteString.copyFrom((byte[])bytes);
    }

    public static String loadResourceAsString(String resourcePath) {
        return TestResourceHelpers.loadResourceAsString(resourcePath, TestResourceHelpers.class);
    }

    public static String loadResourceAsString(String resourcePath, Class<?> clazz) {
        byte[] bytes = TestResourceHelpers.loadResourceAsBytes(resourcePath, clazz);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static byte[] loadResourceAsBytes(String resourcePath) {
        return TestResourceHelpers.loadResourceAsBytes(resourcePath, TestResourceHelpers.class);
    }

    public static byte[] loadResourceAsBytes(String resourcePath, Class<?> clazz) {
        byte[] byArray;
        block9: {
            InputStream stream = clazz.getResourceAsStream(resourcePath);
            try {
                if (stream == null) {
                    throw new IOException("Failed to read resource: " + resourcePath);
                }
                byArray = stream.readAllBytes();
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            stream.close();
        }
        return byArray;
    }
}

